/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.codeInsight.codeFragment.CannotCreateCodeFragmentException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragmentUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.extractmethod.PyExtractMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExtractMethodHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        PyExtractMethodHandler.invokeOnEditor(project, editor, file);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodHandler", "invoke"));
        }
    }

    private static void invokeOnEditor(Project project, Editor editor, PsiFile file) {
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        PsiElement element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        element1 = PyPsiUtils.getSignificantToTheRight(element1, false);
        element2 = PyPsiUtils.getSignificantToTheLeft(element2, false);
        if (element1 == null || element2 == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.using.selected.elements", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return;
        }
        PsiElement[] statements = PyExtractMethodHandler.getStatementsRange(element1, element2);
        if (statements != null) {
            PyCodeFragment fragment;
            ScopeOwner owner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)statements[0], ScopeOwner.class);
            if (owner == null) {
                return;
            }
            try {
                fragment = PyCodeFragmentUtil.createCodeFragment(owner, element1, element2);
            }
            catch (CannotCreateCodeFragmentException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
                return;
            }
            PyExtractMethodUtil.extractFromStatements(project, editor, fragment, statements[0], statements[1]);
            return;
        }
        PyExpression expression = PyRefactoringUtil.getSelectedExpression(project, file, element1, element2);
        if (expression != null) {
            PyCodeFragment fragment;
            ScopeOwner owner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element1, ScopeOwner.class);
            if (owner == null) {
                return;
            }
            try {
                fragment = PyCodeFragmentUtil.createCodeFragment(owner, element1, element2);
            }
            catch (CannotCreateCodeFragmentException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
                return;
            }
            PyExtractMethodUtil.extractFromExpression(project, editor, fragment, (PsiElement)expression);
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.using.selected.elements", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
    }

    @Nullable
    private static PsiElement[] getStatementsRange(PsiElement element1, PsiElement element2) {
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        PyElement statementList = PyPsiUtils.getStatementList(parent);
        if (statementList == null) {
            return null;
        }
        PsiElement statement1 = PyPsiUtils.getStatement((PsiElement)statementList, element1);
        PsiElement statement2 = PyPsiUtils.getStatement((PsiElement)statementList, element2);
        if (statement1 == null || statement2 == null) {
            return null;
        }
        if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)statement1) && element2 == PyPsiUtils.getSignificantToTheLeft(PsiTreeUtil.getDeepestLast((PsiElement)statement2), !(element2 instanceof PsiComment))) {
            return new PsiElement[]{statement1, statement2};
        }
        return null;
    }
}

