/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.ui;

import com.google.common.base.Preconditions;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.ui.PyMemberSelectionTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class PyMemberSelectionPanel
extends JPanel {
    private static final List<PyMemberInfo<PyElement>> EMPTY_MEMBER_INFO = Collections.emptyList();
    private final PyMemberSelectionTable myTable;
    private boolean myInitialized;

    public PyMemberSelectionPanel(@NotNull String title, boolean supportAbstract) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel", "<init>"));
        }
        this(title, EMPTY_MEMBER_INFO, null, supportAbstract);
    }

    public PyMemberSelectionPanel(String title, List<PyMemberInfo<PyElement>> memberInfo, MemberInfoModel<PyElement, PyMemberInfo<PyElement>> model, boolean supportAbstract) {
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)title, (boolean)false);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, emptyBorder);
        this.setBorder(border);
        this.setLayout(new BorderLayout());
        this.myTable = new PyMemberSelectionTable(memberInfo, model, supportAbstract);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable));
        this.add((Component)scrollPane, "Center");
    }

    public void init(@NotNull MemberInfoModel<PyElement, PyMemberInfo<PyElement>> memberInfoModel, @NotNull Collection<PyMemberInfo<PyElement>> members) {
        if (memberInfoModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfoModel", "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel", "init"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel", "init"));
        }
        Preconditions.checkState((!this.myInitialized ? 1 : 0) != 0, (Object)"Already myInitialized");
        this.myTable.setMemberInfos(members);
        this.myTable.setMemberInfoModel(memberInfoModel);
        this.myTable.addMemberInfoChangeListener(memberInfoModel);
        this.myInitialized = true;
    }

    @NotNull
    public Collection<PyMemberInfo<PyElement>> getSelectedMemberInfos() {
        Preconditions.checkState((boolean)this.myInitialized, (Object)"Call #init first");
        Collection<PyMemberInfo<PyElement>> collection = this.myTable.getSelectedMemberInfos();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel", "getSelectedMemberInfos"));
        }
        return collection;
    }

    public void redraw() {
        this.myTable.redraw();
    }
}

