/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyMembersRefactoringBaseProcessor;
import com.jetbrains.python.refactoring.classes.pushDown.PyPushDownHandler;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPushDownProcessor
extends PyMembersRefactoringBaseProcessor {
    private static final String HEADER = RefactoringBundle.message((String)"push.down.members.elements.header");

    public PyPushDownProcessor(@NotNull Project project, @NotNull Collection<PyMemberInfo<PyElement>> membersToMove, @NotNull PyClass from) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "<init>"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "<init>"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "<init>"));
        }
        super(project, membersToMove, from, PyPushDownProcessor.getChildren(from));
    }

    @NotNull
    private static PyClass[] getChildren(@NotNull PyClass from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "getChildren"));
        }
        Collection<PyClass> all = PyPushDownProcessor.getInheritors(from);
        PyClass[] pyClassArray = all.toArray(new PyClass[all.size()]);
        if (pyClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "getChildren"));
        }
        return pyClassArray;
    }

    @NotNull
    static Collection<PyClass> getInheritors(@NotNull PyClass from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "getInheritors"));
        }
        Collection collection = PyClassInheritorsSearch.search(from, false).findAll();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor", "getInheritors"));
        }
        return collection;
    }

    public String getProcessedElementsHeader() {
        return HEADER;
    }

    public String getCodeReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"classes.to.push.down.members.to", (Object[])new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)});
    }

    @Nullable
    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return null;
    }

    @Override
    protected String getCommandName() {
        return PyPushDownHandler.REFACTORING_NAME;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.python.push.down";
    }
}

