/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.pushDown;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Query;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringHandler;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.pushDown.PyPushDownPresenter;
import com.jetbrains.python.refactoring.classes.pushDown.PyPushDownPresenterImpl;
import com.jetbrains.python.refactoring.classes.pushDown.PyPushDownView;
import com.jetbrains.python.refactoring.classes.pushDown.PyPushDownViewSwingImpl;
import com.jetbrains.python.vp.Creator;
import com.jetbrains.python.vp.ViewPresenterUtils;
import org.jetbrains.annotations.NotNull;

public class PyPushDownHandler
extends PyClassRefactoringHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"push.members.down.title");

    @Override
    protected void doRefactorImpl(final @NotNull Project project, final @NotNull PyClass classUnderRefactoring, final @NotNull PyMemberInfoStorage infoStorage, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler", "doRefactorImpl"));
        }
        if (classUnderRefactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classUnderRefactoring", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler", "doRefactorImpl"));
        }
        if (infoStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoStorage", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler", "doRefactorImpl"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler", "doRefactorImpl"));
        }
        Query<PyClass> query = PyClassInheritorsSearch.search(classUnderRefactoring, false);
        if (query.findFirst() == null) {
            String message = RefactoringBundle.message((String)"class.0.does.not.have.inheritors", (Object[])new Object[]{classUnderRefactoring.getName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        ViewPresenterUtils.linkViewWithPresenterAndLaunch(PyPushDownPresenter.class, PyPushDownView.class, new Creator<PyPushDownView, PyPushDownPresenter>(){

            @Override
            @NotNull
            public PyPushDownPresenter createPresenter(@NotNull PyPushDownView view) {
                if (view == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler$1", "createPresenter"));
                }
                PyPushDownPresenterImpl pyPushDownPresenterImpl = new PyPushDownPresenterImpl(project, view, classUnderRefactoring, infoStorage);
                if (pyPushDownPresenterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler$1", "createPresenter"));
                }
                return pyPushDownPresenterImpl;
            }

            @Override
            @NotNull
            public PyPushDownView createView(@NotNull PyPushDownPresenter presenter) {
                if (presenter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presenter", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler$1", "createView"));
                }
                PyPushDownViewSwingImpl pyPushDownViewSwingImpl = new PyPushDownViewSwingImpl(classUnderRefactoring, project, presenter);
                if (pyPushDownViewSwingImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownHandler$1", "createView"));
                }
                return pyPushDownViewSwingImpl;
            }
        });
    }

    @Override
    protected String getTitle() {
        return REFACTORING_NAME;
    }

    @Override
    protected String getHelpId() {
        return "members.push.down";
    }
}

