/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.pullUp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.refactoring.RefactoringBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedViewSwingImpl;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpHandler;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpNothingToRefactorMessage;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpPresenter;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpView;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpViewInitializationInfo;
import com.jetbrains.python.refactoring.classes.ui.PyClassCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class PyPullUpViewSwingImpl
extends MembersBasedViewSwingImpl<PyPullUpPresenter, PyPullUpViewInitializationInfo>
implements PyPullUpView,
ItemListener {
    @NotNull
    private final ComboBox myParentsCombo;
    @NotNull
    private final DefaultComboBoxModel myParentsComboBoxModel;
    @NotNull
    private final PyPullUpNothingToRefactorMessage myNothingToRefactorMessage;

    PyPullUpViewSwingImpl(@NotNull Project project, @NotNull PyPullUpPresenter presenter, @NotNull PyClass clazz, @NotNull PyPullUpNothingToRefactorMessage nothingToRefactorMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "<init>"));
        }
        if (presenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presenter", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "<init>"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "<init>"));
        }
        if (nothingToRefactorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nothingToRefactorMessage", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "<init>"));
        }
        super(project, presenter, RefactoringBundle.message((String)"members.to.be.pulled.up"), true);
        this.setTitle(PyPullUpHandler.REFACTORING_NAME);
        this.myNothingToRefactorMessage = nothingToRefactorMessage;
        this.myParentsComboBoxModel = new DefaultComboBoxModel();
        this.myParentsCombo = new ComboBox((ComboBoxModel)this.myParentsComboBoxModel);
        this.myParentsCombo.setRenderer((ListCellRenderer)new PyClassCellRenderer());
        JLabel mainLabel = new JLabel();
        mainLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{PyClassCellRenderer.getClassText(clazz)}));
        mainLabel.setLabelFor((Component)this.myParentsCombo);
        this.myTopPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        this.myTopPanel.add((Component)mainLabel, gbConstraints);
        this.myTopPanel.add((Component)mainLabel, gbConstraints);
        ++gbConstraints.gridy;
        this.myTopPanel.add((Component)this.myParentsCombo, gbConstraints);
        ++gbConstraints.gridy;
        this.myCenterPanel.add((Component)this.myPyMemberSelectionPanel, "Center");
    }

    @NotNull
    protected String getHelpId() {
        if ("python.reference.pullMembersUp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "getHelpId"));
        }
        return "python.reference.pullMembersUp";
    }

    @Override
    @NotNull
    public PyClass getSelectedParent() {
        PyClass pyClass = (PyClass)this.myParentsComboBoxModel.getSelectedItem();
        if (pyClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "getSelectedParent"));
        }
        return pyClass;
    }

    @Override
    public void showNothingToRefactor() {
        this.myNothingToRefactorMessage.showNothingToRefactor();
    }

    @Override
    public void configure(@NotNull PyPullUpViewInitializationInfo configInfo) {
        if (configInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configInfo", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpViewSwingImpl", "configure"));
        }
        super.configure(configInfo);
        for (PyClass parent : configInfo.getParents()) {
            this.myParentsComboBoxModel.addElement(parent);
        }
        ((PyPullUpPresenter)this.myPresenter).parentChanged();
        this.myParentsCombo.addItemListener((ItemListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.myPyMemberSelectionPanel.redraw();
            ((PyPullUpPresenter)this.myPresenter).parentChanged();
        }
    }
}

