/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.pullUp;

import com.google.common.base.Preconditions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenterWithPreviewImpl;
import com.jetbrains.python.refactoring.classes.pullUp.PyAncestorsUtils;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpInfoModel;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpPresenter;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpProcessor;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpView;
import com.jetbrains.python.refactoring.classes.pullUp.PyPullUpViewInitializationInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PyPullUpPresenterImpl
extends MembersBasedPresenterWithPreviewImpl<PyPullUpView, PyPullUpInfoModel>
implements PyPullUpPresenter {
    @NotNull
    private final Collection<PyClass> myParents;

    PyPullUpPresenterImpl(@NotNull PyPullUpView view, @NotNull PyMemberInfoStorage infoStorage, @NotNull PyClass clazz) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpPresenterImpl", "<init>"));
        }
        if (infoStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoStorage", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpPresenterImpl", "<init>"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpPresenterImpl", "<init>"));
        }
        super(view, clazz, infoStorage, new PyPullUpInfoModel(clazz, view));
        this.myParents = PyAncestorsUtils.getAncestorsUnderUserControl(clazz);
        Preconditions.checkArgument((!this.myParents.isEmpty() ? 1 : 0) != 0, (Object)"No parents found");
    }

    @Override
    public void launch() {
        ((PyPullUpView)this.myView).configure(new PyPullUpViewInitializationInfo((MemberInfoModel<PyElement, PyMemberInfo<PyElement>>)this.myModel, this.myStorage.getClassMemberInfos(this.myClassUnderRefactoring), this.myParents));
        boolean atLeastOneEnabled = false;
        for (PyMemberInfo info : this.myStorage.getClassMemberInfos(this.myClassUnderRefactoring)) {
            if (!((PyPullUpInfoModel)this.myModel).isMemberEnabled(info)) continue;
            atLeastOneEnabled = true;
        }
        if (atLeastOneEnabled) {
            ((PyPullUpView)this.myView).initAndShow();
        } else {
            ((PyPullUpView)this.myView).showNothingToRefactor();
        }
    }

    @Override
    public void okClicked() {
        if (!this.isWritable()) {
            return;
        }
        super.okClicked();
    }

    @Override
    @NotNull
    public BaseRefactoringProcessor createProcessor() {
        PyPullUpProcessor pyPullUpProcessor = new PyPullUpProcessor(this.myClassUnderRefactoring, ((PyPullUpView)this.myView).getSelectedParent(), ((PyPullUpView)this.myView).getSelectedMemberInfos());
        if (pyPullUpProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpPresenterImpl", "createProcessor"));
        }
        return pyPullUpProcessor;
    }

    private boolean isWritable() {
        Collection<PyMemberInfo<PyElement>> infos = ((PyPullUpView)this.myView).getSelectedMemberInfos();
        if (infos.isEmpty()) {
            return true;
        }
        PyElement element = (PyElement)infos.iterator().next().getMember();
        Project project = element.getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)((PyPullUpView)this.myView).getSelectedParent())) {
            return false;
        }
        PyClass container = PyUtil.getContainingClassOrSelf((PsiElement)element);
        if (container == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)container)) {
            return false;
        }
        for (PyMemberInfo<PyElement> info : infos) {
            PyElement member = (PyElement)info.getMember();
            if (CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)member)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void parentChanged() {
        ((PyPullUpInfoModel)this.myModel).setSuperClass(((PyPullUpView)this.myView).getSelectedParent());
    }

    @Override
    @NotNull
    protected Iterable<? extends PyClass> getDestClassesToCheckConflicts() {
        List<PyClass> list = Collections.singletonList(((PyPullUpView)this.myView).getSelectedParent());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pullUp/PyPullUpPresenterImpl", "getDestClassesToCheckConflicts"));
        }
        return list;
    }
}

