/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.pullUp;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class PyAncestorsUtils
extends NotNullPredicate<PyClass> {
    @NotNull
    private final Set<VirtualFile> mySourceRoots;

    @NotNull
    static Collection<PyClass> getAncestorsUnderUserControl(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/pullUp/PyAncestorsUtils", "getAncestorsUnderUserControl"));
        }
        List<PyClass> allAncestors = pyClass.getAncestorClasses(TypeEvalContext.userInitiated(pyClass.getProject(), pyClass.getContainingFile()));
        Collection collection = Collections2.filter(allAncestors, (Predicate)new PyAncestorsUtils(PyUtil.getSourceRoots(pyClass)));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/pullUp/PyAncestorsUtils", "getAncestorsUnderUserControl"));
        }
        return collection;
    }

    private PyAncestorsUtils(@NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/jetbrains/python/refactoring/classes/pullUp/PyAncestorsUtils", "<init>"));
        }
        this.mySourceRoots = Sets.newHashSet(sourceRoots);
    }

    @Override
    public boolean applyNotNull(@NotNull PyClass input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/pullUp/PyAncestorsUtils", "applyNotNull"));
        }
        return VfsUtilCore.isUnder((VirtualFile)input.getContainingFile().getVirtualFile(), this.mySourceRoots);
    }
}

