/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager.vp;

import com.google.common.base.Preconditions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.membersManager.MembersConflictDialog;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenter;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedView;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersViewInitializationInfo;
import com.jetbrains.python.refactoring.classes.ui.PyMemberSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class MembersBasedViewSwingImpl<P extends MembersBasedPresenter, C extends MembersViewInitializationInfo>
extends RefactoringDialog
implements MembersBasedView<C> {
    @NotNull
    protected final JPanel myTopPanel;
    @NotNull
    protected final JComponent myCenterPanel;
    @NotNull
    protected final P myPresenter;
    @NotNull
    protected final PyMemberSelectionPanel myPyMemberSelectionPanel;
    private boolean myConfigured;

    protected MembersBasedViewSwingImpl(@NotNull Project project, @NotNull P presenter, @NotNull String title, boolean supportAbstract) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "<init>"));
        }
        if (presenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presenter", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "<init>"));
        }
        super(project, true);
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.myPresenter = presenter;
        this.myPyMemberSelectionPanel = new PyMemberSelectionPanel(title, supportAbstract);
    }

    @Override
    public boolean showConflictsDialog(@NotNull MultiMap<PyClass, PyMemberInfo<?>> duplicatesConflict, @NotNull Collection<PyMemberInfo<?>> dependenciesConflicts) {
        if (duplicatesConflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicatesConflict", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "showConflictsDialog"));
        }
        if (dependenciesConflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConflicts", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "showConflictsDialog"));
        }
        Preconditions.checkArgument((!duplicatesConflict.isEmpty() || !dependenciesConflicts.isEmpty() ? 1 : 0) != 0, (Object)"Can't show dialog for empty conflicts");
        MembersConflictDialog conflictsDialog = new MembersConflictDialog(this.myProject, duplicatesConflict, dependenciesConflicts);
        conflictsDialog.show();
        return conflictsDialog.isOK();
    }

    @Override
    public void showError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "showError"));
        }
        Messages.showErrorDialog((Component)this.getContentPane(), (String)message);
    }

    @Override
    protected boolean hasPreviewButton() {
        return this.myPresenter.showPreview();
    }

    @Override
    protected void doAction() {
        this.myPresenter.okClicked();
    }

    @NotNull
    protected JComponent createNorthPanel() {
        JPanel jPanel = this.myTopPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "createNorthPanel"));
        }
        return jPanel;
    }

    @Override
    public void close() {
        this.close(0);
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    @Override
    @NotNull
    public Collection<PyMemberInfo<PyElement>> getSelectedMemberInfos() {
        Collection<PyMemberInfo<PyElement>> collection = this.myPyMemberSelectionPanel.getSelectedMemberInfos();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "getSelectedMemberInfos"));
        }
        return collection;
    }

    @Override
    public void invokeRefactoring(@NotNull BaseRefactoringProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "invokeRefactoring"));
        }
        super.invokeRefactoring(processor);
    }

    @Override
    public void configure(@NotNull C configInfo) {
        if (configInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configInfo", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedViewSwingImpl", "configure"));
        }
        Preconditions.checkArgument((!this.myConfigured ? 1 : 0) != 0, (Object)"Already configured");
        this.myConfigured = true;
        this.myPyMemberSelectionPanel.init(((MembersViewInitializationInfo)configInfo).getMemberInfoModel(), ((MembersViewInitializationInfo)configInfo).getMemberInfos());
    }

    @Override
    public void initAndShow() {
        Preconditions.checkArgument((boolean)this.myConfigured, (Object)"Not configured, run 'configure' first!");
        this.init();
        this.myPyMemberSelectionPanel.redraw();
        this.show();
    }
}

