/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager.vp;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.vp.BadDataException;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenter;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedView;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

abstract class MembersBasedPresenterImpl<T extends MembersBasedView<?>, M extends MemberInfoModel<PyElement, PyMemberInfo<PyElement>>>
implements MembersBasedPresenter {
    @NotNull
    protected final T myView;
    @NotNull
    protected final PyClass myClassUnderRefactoring;
    @NotNull
    protected final PyMemberInfoStorage myStorage;
    @NotNull
    protected final M myModel;

    MembersBasedPresenterImpl(@NotNull T view, @NotNull PyClass classUnderRefactoring, @NotNull PyMemberInfoStorage infoStorage, @NotNull M model) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl", "<init>"));
        }
        if (classUnderRefactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classUnderRefactoring", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl", "<init>"));
        }
        if (infoStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoStorage", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl", "<init>"));
        }
        this.myView = view;
        this.myClassUnderRefactoring = classUnderRefactoring;
        this.myStorage = infoStorage;
        this.myModel = model;
    }

    @Override
    public void okClicked() {
        MultiMap<PyClass, PyMemberInfo<?>> conflicts = this.getConflicts();
        ArrayList dependencyConflicts = new ArrayList();
        for (PyMemberInfo memberInfo : this.myStorage.getClassMemberInfos(this.myClassUnderRefactoring)) {
            if (this.myModel.checkForProblems((MemberInfoBase)memberInfo) == 0) continue;
            dependencyConflicts.add(memberInfo);
        }
        if (conflicts.isEmpty() && dependencyConflicts.isEmpty() || this.myView.showConflictsDialog(conflicts, dependencyConflicts)) {
            try {
                this.validateView();
                this.doRefactor();
            }
            catch (BadDataException e) {
                this.myView.showError(e.getMessage());
            }
        }
    }

    protected void validateView() throws BadDataException {
        if (this.myView.getSelectedMemberInfos().isEmpty()) {
            throw new BadDataException(RefactoringBundle.message((String)"no.members.selected"));
        }
    }

    abstract void doRefactor();

    @NotNull
    protected final MultiMap<PyClass, PyMemberInfo<?>> getConflicts() {
        MultiMap result = new MultiMap();
        Collection<PyMemberInfo<PyElement>> memberInfos = this.myView.getSelectedMemberInfos();
        for (PyClass destinationClass : this.getDestClassesToCheckConflicts()) {
            for (PyMemberInfo<PyElement> pyMemberInfo : memberInfos) {
                if (!pyMemberInfo.hasConflict(destinationClass)) continue;
                result.putValue((Object)destinationClass, pyMemberInfo);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/vp/MembersBasedPresenterImpl", "getConflicts"));
        }
        return multiMap;
    }

    @NotNull
    protected abstract Iterable<? extends PyClass> getDestClassesToCheckConflicts();
}

