/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class TypeSafeMovingStrategy<T extends PyElement> {
    @NotNull
    private final PyClass myFrom;
    @NotNull
    private final MembersManager<T> myManager;
    @NotNull
    private final Collection<PyMemberInfo<T>> myMemberInfoCollection;
    @NotNull
    private final PyClass[] myTo;

    static void moveCheckingTypesAtRunTime(@NotNull PyClass from, @NotNull MembersManager<?> manager, @NotNull Collection<PyMemberInfo<PyElement>> memberInfoCollection, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "moveCheckingTypesAtRunTime"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "moveCheckingTypesAtRunTime"));
        }
        if (memberInfoCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfoCollection", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "moveCheckingTypesAtRunTime"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "moveCheckingTypesAtRunTime"));
        }
        manager.checkElementTypes(MembersManager.fetchElements(memberInfoCollection));
        super.moveTyped();
    }

    private TypeSafeMovingStrategy(@NotNull PyClass from, @NotNull MembersManager<T> manager, @NotNull Collection<PyMemberInfo<T>> memberInfoCollection, @NotNull PyClass[] to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "<init>"));
        }
        if (memberInfoCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfoCollection", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "<init>"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/TypeSafeMovingStrategy", "<init>"));
        }
        this.myFrom = from;
        this.myManager = manager;
        this.myMemberInfoCollection = new ArrayList<PyMemberInfo<T>>(memberInfoCollection);
        this.myTo = (PyClass[])to.clone();
    }

    private void moveTyped() {
        Collection<T> elementsCollection = MembersManager.fetchElements(this.myMemberInfoCollection);
        Collection<PyElement> references = this.myManager.getElementsToStoreReferences(elementsCollection);
        for (PyElement element : references) {
            PyClassRefactoringUtil.rememberNamedReferences((PsiElement)element, "self");
        }
        Collection<PyElement> newElements = this.myManager.moveMembers(this.myFrom, this.myMemberInfoCollection, this.myTo);
        for (PyElement element : newElements) {
            PyClassRefactoringUtil.restoreNamedReferences((PsiElement)element);
        }
    }
}

