/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.ui.PyClassCellRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SuperClassesManager
extends MembersManager<PyClass> {
    private static final NoFakeSuperClasses NO_FAKE_SUPER_CLASSES = new NoFakeSuperClasses();

    SuperClassesManager() {
        super(PyClass.class);
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedElements", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getDependencies"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)usedElements.keySet());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getDependencies"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getDependencies"));
        }
        MultiMap multiMap = MultiMap.emptyInstance();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getDependencies"));
        }
        return multiMap;
    }

    @Override
    public boolean hasConflict(@NotNull PyClass member, @NotNull PyClass aClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "hasConflict"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "hasConflict"));
        }
        List<PyExpression> expressionList = SuperClassesManager.getExpressionsBySuperClass(aClass, Collections.singleton(member));
        return !expressionList.isEmpty();
    }

    @Override
    @NotNull
    protected List<PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getMembersCouldBeMoved"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(Arrays.asList(pyClass.getSuperClasses()), (Predicate)NO_FAKE_SUPER_CLASSES));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getMembersCouldBeMoved"));
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyClass>> members, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "moveMembers"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "moveMembers"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "moveMembers"));
        }
        Collection<PyClass> elements = SuperClassesManager.fetchElements(members);
        for (PyClass destClass : to) {
            PyClassRefactoringUtil.addSuperclasses(from.getProject(), destClass, elements.toArray(new PyClass[members.size()]));
        }
        List<PyExpression> expressionsToDelete = SuperClassesManager.getExpressionsBySuperClass(from, elements);
        for (PyExpression expressionToDelete : expressionsToDelete) {
            expressionToDelete.delete();
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<PyExpression> getExpressionsBySuperClass(@NotNull PyClass from, @NotNull Collection<PyClass> classes) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getExpressionsBySuperClass"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getExpressionsBySuperClass"));
        }
        ArrayList<PyExpression> expressionsToDelete = new ArrayList<PyExpression>(classes.size());
        for (PyExpression expression : from.getSuperClassExpressions()) {
            if (!(expression instanceof PyQualifiedExpression)) continue;
            PyReferenceExpression reference = (PyReferenceExpression)expression;
            for (PyClass element : classes) {
                if (!reference.getReference().isReferenceTo((PsiElement)element)) continue;
                expressionsToDelete.add(expression);
            }
        }
        ArrayList<PyExpression> arrayList = expressionsToDelete;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "getExpressionsBySuperClass"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyClass> apply(@NotNull PyClass input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "apply"));
        }
        String name = RefactoringBundle.message((String)"member.info.extends.0", (Object[])new Object[]{PyClassCellRenderer.getClassText(input)});
        PyMemberInfo<PyClass> pyMemberInfo = new PyMemberInfo<PyClass>(input, false, name, false, this, false);
        if (pyMemberInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager", "apply"));
        }
        return pyMemberInfo;
    }

    private static class NoFakeSuperClasses
    extends NotNullPredicate<PyClass> {
        private NoFakeSuperClasses() {
        }

        @Override
        protected boolean applyNotNull(@NotNull PyClass input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/SuperClassesManager$NoFakeSuperClasses", "applyNotNull"));
            }
            return !"___Classobj".equals(input.getName());
        }
    }
}

