/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyUsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyMembersRefactoringBaseProcessor
extends BaseRefactoringProcessor
implements UsageViewDescriptor {
    @NotNull
    protected final Collection<PyMemberInfo<PyElement>> myMembersToMove;
    @NotNull
    protected final PyClass myFrom;
    @NotNull
    private final PyClass[] myTo;

    protected PyMembersRefactoringBaseProcessor(@NotNull Project project, @NotNull Collection<PyMemberInfo<PyElement>> membersToMove, @NotNull PyClass from, PyClass ... to) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "<init>"));
        }
        if (membersToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersToMove", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "<init>"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "<init>"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "<init>"));
        }
        super(project);
        this.myFrom = from;
        this.myMembersToMove = new ArrayList<PyMemberInfo<PyElement>>(membersToMove);
        this.myTo = (PyClass[])to.clone();
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        PyMembersRefactoringBaseProcessor pyMembersRefactoringBaseProcessor = this;
        if (pyMembersRefactoringBaseProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "createUsageViewDescriptor"));
        }
        return pyMembersRefactoringBaseProcessor;
    }

    @NotNull
    public PsiElement[] getElements() {
        PsiElement[] psiElementArray = (PsiElement[])this.myTo.clone();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "getElements"));
        }
        return psiElementArray;
    }

    @NotNull
    protected final PyUsageInfo[] findUsages() {
        ArrayList<PyUsageInfo> result = new ArrayList<PyUsageInfo>(this.myTo.length);
        for (PyClass pyDestinationClass : this.myTo) {
            result.add(new PyUsageInfo(pyDestinationClass));
        }
        PyUsageInfo[] pyUsageInfoArray = result.toArray(new PyUsageInfo[result.size()]);
        if (pyUsageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor", "findUsages"));
        }
        return pyUsageInfoArray;
    }

    @Override
    protected final void performRefactoring(UsageInfo[] usages) {
        ArrayList<PyClass> destinations = new ArrayList<PyClass>(usages.length);
        for (UsageInfo usage : usages) {
            if (!(usage instanceof PyUsageInfo)) {
                throw new IllegalArgumentException("Only PyUsageInfo is accepted here");
            }
            destinations.add(((PyUsageInfo)usage).getTo());
        }
        MembersManager.moveAllMembers(this.myMembersToMove, this.myFrom, destinations.toArray(new PyClass[destinations.size()]));
        PyClassRefactoringUtil.optimizeImports(this.myFrom.getContainingFile());
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myFrom);
        data.addMembers((Object[])this.myMembersToMove.toArray(new PyMemberInfo[this.myMembersToMove.size()]), (Function)new Function<PyMemberInfo, PsiElement>(){

            public PsiElement fun(PyMemberInfo info) {
                return info.getMember();
            }
        });
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo[] usages) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTo);
        return data;
    }
}

