/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.classes.membersManager.ClassFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.MethodsManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PropertiesManager
extends MembersManager<PyElement> {
    PropertiesManager() {
        super(PyElement.class);
    }

    @Override
    @NotNull
    protected List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getMembersCouldBeMoved"));
        }
        ArrayList<PyElement> elements = new ArrayList<PyElement>(pyClass.getProperties().size());
        for (Property property : pyClass.getProperties().values()) {
            elements.add(PropertiesManager.getElement(property));
        }
        ArrayList<PyElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getMembersCouldBeMoved"));
        }
        return arrayList;
    }

    @NotNull
    private static PyElement getElement(@NotNull Property property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getElement"));
        }
        Callable getter = property.getGetter().valueOrNull();
        Callable setter = property.getSetter().valueOrNull();
        Callable deleter = property.getDeleter().valueOrNull();
        if (getter != null) {
            Callable callable = getter;
            if (callable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getElement"));
            }
            return callable;
        }
        if (setter != null) {
            Callable callable = setter;
            if (callable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getElement"));
            }
            return callable;
        }
        if (deleter != null) {
            Callable callable = deleter;
            if (callable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getElement"));
            }
            return callable;
        }
        PyTargetExpression site = property.getDefinitionSite();
        assert (site != null) : "Property has no methods nor declaration. That is not property";
        PyTargetExpression pyTargetExpression = site;
        if (pyTargetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getElement"));
        }
        return pyTargetExpression;
    }

    @NotNull
    private static Property getProperty(@NotNull PyClass pyClass, @NotNull PyElement element) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getProperty"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getProperty"));
        }
        Collection<Property> properties = pyClass.getProperties().values();
        if (element instanceof PyTargetExpression) {
            Property property = PropertiesManager.getPropertyByTargetExpression(properties, (PyTargetExpression)element);
            if (property == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getProperty"));
            }
            return property;
        }
        if (element instanceof PyFunction) {
            Property property = PropertiesManager.getPropertyByFunction(properties, (PyFunction)element);
            if (property == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getProperty"));
            }
            return property;
        }
        throw new IllegalArgumentException("Not function nor target");
    }

    @NotNull
    private static Property getPropertyByFunction(@NotNull Collection<Property> properties, @NotNull PyFunction functionToSearch) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getPropertyByFunction"));
        }
        if (functionToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionToSearch", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getPropertyByFunction"));
        }
        for (Property property : properties) {
            for (PyFunction function : PropertiesManager.getAllFunctions(property)) {
                if (!function.equals(functionToSearch)) continue;
                Property property2 = property;
                if (property2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getPropertyByFunction"));
                }
                return property2;
            }
        }
        throw new IllegalArgumentException("No property found");
    }

    @NotNull
    private static Property getPropertyByTargetExpression(@NotNull Iterable<Property> properties, @NotNull PyTargetExpression element) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getPropertyByTargetExpression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getPropertyByTargetExpression"));
        }
        for (Property property : properties) {
            if (!element.equals(property.getDefinitionSite())) continue;
            Property property2 = property;
            if (property2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getPropertyByTargetExpression"));
            }
            return property2;
        }
        throw new IllegalArgumentException("No property found");
    }

    @NotNull
    private static Collection<PyFunction> getAllFunctions(@NotNull Property property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getAllFunctions"));
        }
        ArrayList<PyFunction> result = new ArrayList<PyFunction>(3);
        Callable getter = property.getGetter().valueOrNull();
        Callable setter = property.getSetter().valueOrNull();
        Callable deleter = property.getDeleter().valueOrNull();
        if (getter instanceof PyFunction) {
            result.add((PyFunction)getter);
        }
        if (setter instanceof PyFunction) {
            result.add((PyFunction)setter);
        }
        if (deleter instanceof PyFunction) {
            result.add((PyFunction)deleter);
        }
        ArrayList<PyFunction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getAllFunctions"));
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyElement>> members, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "moveMembers"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "moveMembers"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "moveMembers"));
        }
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        Collection<PyElement> elements = PropertiesManager.fetchElements(members);
        for (PyElement element : elements) {
            Property property = PropertiesManager.getProperty(from, element);
            Collection<PyFunction> functions = PropertiesManager.getAllFunctions(property);
            MethodsManager.moveMethods(from, functions, false, to);
            PyTargetExpression definitionSite = property.getDefinitionSite();
            if (definitionSite == null) continue;
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)definitionSite, PyAssignmentStatement.class);
            ClassFieldsManager.moveAssignmentsImpl(from, Collections.singleton(assignmentStatement), to);
        }
        return result;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyElement> apply(@NotNull PyElement input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "apply"));
        }
        PyMemberInfo<PyElement> pyMemberInfo = new PyMemberInfo<PyElement>(input, false, PropertiesManager.getName(input), false, this, false);
        if (pyMemberInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "apply"));
        }
        return pyMemberInfo;
    }

    private static String getName(@NotNull PyElement input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getName"));
        }
        PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)input, PyClass.class);
        assert (clazz != null) : "Element not declared in class";
        Property property = PropertiesManager.getProperty(clazz, input);
        return property.getName();
    }

    @Override
    public boolean hasConflict(@NotNull PyElement member, @NotNull PyClass aClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "hasConflict"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "hasConflict"));
        }
        return false;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getDependencies"));
        }
        PyReferenceVisitor visitor = new PyReferenceVisitor();
        member.accept(visitor);
        MultiMap<PyClass, PyElement> multiMap = visitor.myResult;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getDependencies"));
        }
        return multiMap;
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedElements", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getDependencies"));
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/PropertiesManager", "getDependencies"));
        }
        return list;
    }

    private static class PyReferenceVisitor
    extends PyRecursiveElementVisitorWithResult {
        private PyReferenceVisitor() {
        }

        @Override
        public void visitPyExpression(PyExpression node) {
            PyClass pyClass;
            PsiReference reference = node.getReference();
            if (reference == null) {
                return;
            }
            PsiElement declaration = reference.resolve();
            if (!(declaration instanceof PyFunction)) {
                return;
            }
            PyFunction function = (PyFunction)declaration;
            Property property = function.getProperty();
            if (property == null) {
                return;
            }
            PyClass aClass = function.getContainingClass();
            if (aClass == null) {
                return;
            }
            Collection functions = PropertiesManager.getAllFunctions(property);
            for (PyFunction pyFunction : functions) {
                PyClass functionClass = pyFunction.getContainingClass();
                if (functionClass == null) continue;
                this.myResult.putValue((Object)functionClass, (Object)pyFunction);
            }
            PyTargetExpression definitionSite = property.getDefinitionSite();
            if (definitionSite != null && (pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)definitionSite, PyClass.class)) != null) {
                this.myResult.putValue((Object)pyClass, (Object)definitionSite);
            }
        }
    }
}

