/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.navigation.NavigationItem;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyElement;
import org.jetbrains.annotations.NotNull;

class NamePredicate
extends NotNullPredicate<PyElement> {
    @NotNull
    private final String myName;

    NamePredicate(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/classes/membersManager/NamePredicate", "<init>"));
        }
        this.myName = name;
    }

    @Override
    protected boolean applyNotNull(@NotNull PyElement input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/NamePredicate", "applyNotNull"));
        }
        return this.myName.equals(input.getName());
    }

    static boolean hasElementWithSameName(@NotNull NavigationItem needle, @NotNull Iterable<? extends PyElement> stock) {
        if (needle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "needle", "com/jetbrains/python/refactoring/classes/membersManager/NamePredicate", "hasElementWithSameName"));
        }
        if (stock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stock", "com/jetbrains/python/refactoring/classes/membersManager/NamePredicate", "hasElementWithSameName"));
        }
        String name = needle.getName();
        if (name != null) {
            Optional optional = Iterables.tryFind(stock, (Predicate)new NamePredicate(name));
            return optional.isPresent();
        }
        return false;
    }
}

