/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import com.jetbrains.python.refactoring.classes.membersManager.NamelessFilter;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodsManager
extends MembersManager<PyFunction> {
    private static final String ABC_META_CLASS = "ABCMeta";
    private static final String[] DECORATORS_MAY_BE_COPIED_TO_ABSTRACT = new String[]{"property", "classmethod", "staticmethod"};
    public static final String ABC_META_PACKAGE = "abc";
    private static final NoPropertiesPredicate NO_PROPERTIES = new NoPropertiesPredicate();

    MethodsManager() {
        super(PyFunction.class);
    }

    @Override
    public boolean hasConflict(@NotNull PyFunction member, @NotNull PyClass aClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "hasConflict"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "hasConflict"));
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, Arrays.asList(aClass.getMethods(false)));
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedElements", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "getDependencies"));
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "getDependencies"));
        }
        return list;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "getDependencies"));
        }
        MyPyRecursiveElementVisitor visitor = new MyPyRecursiveElementVisitor();
        member.accept(visitor);
        MultiMap multiMap = visitor.myResult;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "getDependencies"));
        }
        return multiMap;
    }

    @Override
    @NotNull
    protected List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "getMembersCouldBeMoved"));
        }
        ImmutableList immutableList = FluentIterable.from(Arrays.asList(pyClass.getMethods(false))).filter(new NamelessFilter()).filter((Predicate)NO_PROPERTIES).toList();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "getMembersCouldBeMoved"));
        }
        return immutableList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyFunction>> members, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "moveMembers"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "moveMembers"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "moveMembers"));
        }
        Collection<PyFunction> methodsToMove = MethodsManager.fetchElements(Collections2.filter(members, (Predicate)new AbstractFilter(false)));
        Collection<PyFunction> methodsToAbstract = MethodsManager.fetchElements(Collections2.filter(members, (Predicate)new AbstractFilter(true)));
        MethodsManager.makeMethodsAbstract(methodsToAbstract, to);
        return MethodsManager.moveMethods(from, methodsToMove, true, to);
    }

    private static void makeMethodsAbstract(Collection<PyFunction> currentFunctions, PyClass ... to) {
        HashSet<PsiFile> filesToCheckImport = new HashSet<PsiFile>();
        HashSet<PyClass> classesToAddMetaAbc = new HashSet<PyClass>();
        for (PyFunction function : currentFunctions) {
            for (PyClass destClass : to) {
                PyFunctionBuilder functionBuilder = PyFunctionBuilder.copySignature(function, DECORATORS_MAY_BE_COPIED_TO_ABSTRACT);
                functionBuilder.decorate("abstractmethod");
                LanguageLevel level = LanguageLevel.forElement(destClass);
                PyClassRefactoringUtil.addMethods(destClass, false, functionBuilder.buildFunction(destClass.getProject(), level));
                classesToAddMetaAbc.add(destClass);
            }
        }
        for (PyClass aClass : classesToAddMetaAbc) {
            if (!MethodsManager.addMetaAbcIfNeeded(aClass)) continue;
            filesToCheckImport.add(aClass.getContainingFile());
        }
        for (PsiFile file : filesToCheckImport) {
            MethodsManager.addImportFromAbc(file, "abstractmethod");
            MethodsManager.addImportFromAbc(file, ABC_META_CLASS);
            PyClassRefactoringUtil.optimizeImports(file);
        }
    }

    private static boolean addMetaAbcIfNeeded(@NotNull PyClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "addMetaAbcIfNeeded"));
        }
        PsiFile file = aClass.getContainingFile();
        PyType type = aClass.getMetaClassType(TypeEvalContext.userInitiated(aClass.getProject(), file));
        if (type != null) {
            return false;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement(aClass);
        if (languageLevel.isPy3K()) {
            PyClassRefactoringUtil.addSuperClassExpressions(aClass.getProject(), aClass, null, Collections.singletonList(Pair.create((Object)"metaclass", (Object)ABC_META_CLASS)));
        } else {
            PyClassRefactoringUtil.addClassAttributeIfNotExist(aClass, "__metaclass__", ABC_META_CLASS);
        }
        return true;
    }

    private static void addImportFromAbc(@NotNull PsiFile file, @NotNull String nameToImport) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "addImportFromAbc"));
        }
        if (nameToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToImport", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "addImportFromAbc"));
        }
        AddImportHelper.addFromImportStatement(file, ABC_META_PACKAGE, nameToImport, null, AddImportHelper.ImportPriority.BUILTIN, null);
    }

    static List<PyElement> moveMethods(PyClass from, Collection<PyFunction> methodsToMove, boolean skipIfExist, PyClass ... to) {
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        for (PyClass destClass : to) {
            ArrayList<PyFunction> copies = new ArrayList<PyFunction>(methodsToMove.size());
            for (PyFunction element : methodsToMove) {
                PyFunction newMethod = (PyFunction)element.copy();
                copies.add(newMethod);
            }
            result.addAll(PyClassRefactoringUtil.copyMethods(copies, destClass, skipIfExist));
        }
        MethodsManager.deleteElements(methodsToMove);
        PyClassRefactoringUtil.insertPassIfNeeded(from);
        return result;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyFunction> apply(@NotNull PyFunction pyFunction) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "apply"));
        }
        PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(pyFunction);
        assert (flags != null) : "No flags return while element is function " + pyFunction;
        boolean isStatic = flags.isStaticMethod() || flags.isClassMethod();
        PyMemberInfo<PyFunction> pyMemberInfo = new PyMemberInfo<PyFunction>(pyFunction, isStatic, MethodsManager.buildDisplayMethodName(pyFunction), MethodsManager.isOverrides(pyFunction), this, MethodsManager.couldBeAbstract(pyFunction));
        if (pyMemberInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "apply"));
        }
        return pyMemberInfo;
    }

    private static boolean couldBeAbstract(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "couldBeAbstract"));
        }
        if (PyUtil.isInit(function)) {
            return false;
        }
        PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(function);
        assert (flags != null) : "Function should be called on method!";
        boolean py3K = LanguageLevel.forElement(function).isPy3K();
        return flags.isInstanceMethod() || py3K;
    }

    @Nullable
    private static Boolean isOverrides(PyFunction pyFunction) {
        PyClass clazz = PyUtil.getContainingClassOrSelf(pyFunction);
        assert (clazz != null) : "Refactoring called on function, not method: " + pyFunction;
        for (PyClass parentClass : clazz.getSuperClasses()) {
            PyFunction parentMethod = parentClass.findMethodByName(pyFunction.getName(), true);
            if (parentMethod == null) continue;
            return true;
        }
        return null;
    }

    @NotNull
    private static String buildDisplayMethodName(@NotNull PyFunction pyFunction) {
        PyParameter[] arguments;
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "buildDisplayMethodName"));
        }
        StringBuilder builder = new StringBuilder(pyFunction.getName());
        builder.append('(');
        for (PyParameter parameter : arguments = pyFunction.getParameterList().getParameters()) {
            builder.append(parameter.getName());
            if (arguments.length <= 1 || parameter == arguments[arguments.length - 1]) continue;
            builder.append(", ");
        }
        builder.append(')');
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager", "buildDisplayMethodName"));
        }
        return string;
    }

    private static class NoPropertiesPredicate
    implements Predicate<PyFunction> {
        private NoPropertiesPredicate() {
        }

        public boolean apply(@NotNull PyFunction input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager$NoPropertiesPredicate", "apply"));
            }
            return input.getProperty() == null;
        }
    }

    private static class MyPyRecursiveElementVisitor
    extends PyRecursiveElementVisitorWithResult {
        private MyPyRecursiveElementVisitor() {
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyFunction calleeFunction;
            PyClass clazz;
            PsiElement calleeDeclaration;
            PsiReference calleeRef;
            PyExpression callee = node.getCallee();
            if (callee != null && (calleeRef = callee.getReference()) != null && (calleeDeclaration = calleeRef.resolve()) instanceof PyFunction && (clazz = (calleeFunction = (PyFunction)calleeDeclaration).getContainingClass()) != null) {
                if (PyUtil.isInit(calleeFunction)) {
                    return;
                }
                this.myResult.putValue((Object)clazz, (Object)calleeFunction);
            }
        }
    }

    private static class AbstractFilter
    extends NotNullPredicate<PyMemberInfo<PyFunction>> {
        private final boolean myAllowAbstractOnly;

        private AbstractFilter(boolean allowAbstractOnly) {
            this.myAllowAbstractOnly = allowAbstractOnly;
        }

        @Override
        protected boolean applyNotNull(@NotNull PyMemberInfo<PyFunction> input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager$AbstractFilter", "applyNotNull"));
            }
            return input.isToAbstract() == this.myAllowAbstractOnly;
        }
    }
}

