/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import com.jetbrains.python.refactoring.classes.membersManager.ClassFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.InstanceFieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.MethodsManager;
import com.jetbrains.python.refactoring.classes.membersManager.PropertiesManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.SuperClassesManager;
import com.jetbrains.python.refactoring.classes.membersManager.TypeSafeMovingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MembersManager<T extends PyElement>
implements Function<T, PyMemberInfo<T>> {
    private static final Collection<? extends MembersManager<? extends PyElement>> MANAGERS = Arrays.asList(new MethodsManager(), new SuperClassesManager(), new ClassFieldsManager(), new InstanceFieldsManager(), new PropertiesManager());
    @NotNull
    private final Class<T> myExpectedClass;

    protected MembersManager(@NotNull Class<T> expectedClass) {
        if (expectedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedClass", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "<init>"));
        }
        this.myExpectedClass = expectedClass;
    }

    @NotNull
    public static List<PyMemberInfo<PyElement>> getAllMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "getAllMembersCouldBeMoved"));
        }
        ArrayList<PyMemberInfo<PyElement>> result = new ArrayList<PyMemberInfo<PyElement>>();
        for (MembersManager<? extends PyElement> membersManager : MANAGERS) {
            result.addAll(MembersManager.transformSafely(pyClass, membersManager));
        }
        ArrayList<PyMemberInfo<PyElement>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "getAllMembersCouldBeMoved"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PyMemberInfo<PyElement>> transformSafely(@NotNull PyClass pyClass, @NotNull MembersManager<?> manager) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "transformSafely"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "transformSafely"));
        }
        List<PyElement> membersCouldBeMoved = manager.getMembersCouldBeMoved(pyClass);
        manager.checkElementTypes(membersCouldBeMoved);
        Collection collection = Collections2.transform(membersCouldBeMoved, manager);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "transformSafely"));
        }
        return collection;
    }

    public static void moveAllMembers(@NotNull Collection<PyMemberInfo<PyElement>> memberInfos, @NotNull PyClass from, PyClass ... to) {
        if (memberInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfos", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "moveAllMembers"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "moveAllMembers"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "moveAllMembers"));
        }
        ArrayList<PyMemberInfo<PyElement>> memberInfosSorted = new ArrayList<PyMemberInfo<PyElement>>(memberInfos);
        Collections.sort(memberInfosSorted, new Comparator<PyMemberInfo<PyElement>>(){

            @Override
            public int compare(PyMemberInfo<PyElement> o1, PyMemberInfo<PyElement> o2) {
                return PyDependenciesComparator.INSTANCE.compare((PyElement)o1.getMember(), (PyElement)o2.getMember());
            }
        });
        for (PyMemberInfo pyMemberInfo : memberInfosSorted) {
            TypeSafeMovingStrategy.moveCheckingTypesAtRunTime(from, pyMemberInfo.getMembersManager(), Collections.singleton(pyMemberInfo), to);
        }
        PyClassRefactoringUtil.insertPassIfNeeded(from);
    }

    void checkElementTypes(@NotNull Iterable<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "checkElementTypes"));
        }
        for (PyElement pyElement : elements) {
            Preconditions.checkArgument((boolean)this.myExpectedClass.isAssignableFrom(pyElement.getClass()), (Object)String.format("Manager %s expected %s but got %s", this, this.myExpectedClass, pyElement));
        }
    }

    @Nullable
    public static PyMemberInfo<PyElement> findMember(@NotNull Collection<PyMemberInfo<PyElement>> members, @NotNull Predicate<PyMemberInfo<PyElement>> predicate) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
        }
        for (PyMemberInfo<PyElement> pyMemberInfo : members) {
            if (!predicate.apply(pyMemberInfo)) continue;
            return pyMemberInfo;
        }
        return null;
    }

    @Nullable
    public static PyMemberInfo<PyElement> findMember(@NotNull PyClass pyClass, @NotNull Predicate<PyMemberInfo<PyElement>> predicate) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
        }
        return MembersManager.findMember(MembersManager.getAllMembersCouldBeMoved(pyClass), predicate);
    }

    @NotNull
    public static PyMemberInfo<PyElement> findMember(@NotNull PyClass pyClass, @NotNull PyElement pyElement) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
        }
        if (pyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyElement", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
        }
        PyMemberInfo<PyElement> result = MembersManager.findMember(pyClass, (Predicate<PyMemberInfo<PyElement>>)new FindByElement(pyElement));
        if (result != null) {
            PyMemberInfo<PyElement> pyMemberInfo = result;
            if (pyMemberInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "findMember"));
            }
            return pyMemberInfo;
        }
        throw new IllegalArgumentException(String.format("Element %s not found in class %s or can't be moved", pyElement, pyClass));
    }

    @NotNull
    protected abstract List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass var1);

    protected Collection<? extends PyElement> getElementsToStoreReferences(@NotNull Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "getElementsToStoreReferences"));
        }
        return elements;
    }

    protected abstract Collection<PyElement> moveMembers(@NotNull PyClass var1, @NotNull Collection<PyMemberInfo<T>> var2, PyClass ... var3);

    @NotNull
    public abstract PyMemberInfo<T> apply(@NotNull T var1);

    protected static void deleteElements(@NotNull Collection<? extends PsiElement> pyElementsToDelete) {
        if (pyElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyElementsToDelete", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "deleteElements"));
        }
        for (PsiElement psiElement : pyElementsToDelete) {
            psiElement.delete();
        }
    }

    @NotNull
    protected static <T extends PyElement> Collection<T> fetchElements(@NotNull Collection<PyMemberInfo<T>> memberInfos) {
        if (memberInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfos", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "fetchElements"));
        }
        Collection collection = Collections2.transform(memberInfos, new PyMemberExtractor());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "fetchElements"));
        }
        return collection;
    }

    public abstract boolean hasConflict(@NotNull T var1, @NotNull PyClass var2);

    @NotNull
    public static Collection<? extends PyElement> getAllDependencies(@NotNull PyClass classWhereMemberDeclared, @NotNull PyElement member, @Nullable PyClass destinationClass) {
        if (classWhereMemberDeclared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classWhereMemberDeclared", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "getAllDependencies"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "getAllDependencies"));
        }
        PyMemberInfo<PyElement> memberInfo = MembersManager.findMember(classWhereMemberDeclared, member);
        Collection<PyElement> elementsToCheckDependency = memberInfo.getMembersManager().getElementsToStoreReferences(Collections.singleton(member));
        MultiMap dependencies = new MultiMap();
        HashSet<PyElement> result = new HashSet<PyElement>();
        for (MembersManager<? extends PyElement> membersManager : MANAGERS) {
            for (PyElement elementToCheckDependency : elementsToCheckDependency) {
                dependencies.putAllValues(membersManager.getDependencies(elementToCheckDependency));
            }
        }
        if (destinationClass != null) {
            Iterator classesIterator = dependencies.keySet().iterator();
            while (classesIterator.hasNext()) {
                PyClass pyClass = (PyClass)classesIterator.next();
                if (!pyClass.equals(destinationClass) && !ArrayUtil.contains((Object)pyClass, (Object[])destinationClass.getSuperClasses())) continue;
                classesIterator.remove();
            }
        }
        for (MembersManager<? extends PyElement> membersManager : MANAGERS) {
            result.addAll(membersManager.getDependencies((MultiMap<PyClass, PyElement>)dependencies));
        }
        result.addAll(dependencies.values());
        HashSet<PyElement> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager", "getAllDependencies"));
        }
        return hashSet;
    }

    @NotNull
    protected abstract MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement var1);

    @NotNull
    protected abstract Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> var1);

    private static class FindByElement
    extends NotNullPredicate<PyMemberInfo<PyElement>> {
        private final PyElement myPyElement;

        private FindByElement(PyElement pyElement) {
            this.myPyElement = pyElement;
        }

        @Override
        public boolean applyNotNull(@NotNull PyMemberInfo<PyElement> input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager$FindByElement", "applyNotNull"));
            }
            return ((PyElement)input.getMember()).equals(this.myPyElement);
        }
    }

    private static class PyMemberExtractor<T extends PyElement>
    implements Function<PyMemberInfo<T>, T> {
        private PyMemberExtractor() {
        }

        public T apply(@NotNull PyMemberInfo<T> input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MembersManager$PyMemberExtractor", "apply"));
            }
            return (T)((PyElement)input.getMember());
        }
    }
}

