/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MembersConflictDialog
extends ConflictsDialog {
    public MembersConflictDialog(@NotNull Project project, @NotNull MultiMap<PyClass, PyMemberInfo<?>> duplicatesConflict, @NotNull Collection<PyMemberInfo<?>> dependenciesConflicts) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/membersManager/MembersConflictDialog", "<init>"));
        }
        if (duplicatesConflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicatesConflict", "com/jetbrains/python/refactoring/classes/membersManager/MembersConflictDialog", "<init>"));
        }
        if (dependenciesConflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConflicts", "com/jetbrains/python/refactoring/classes/membersManager/MembersConflictDialog", "<init>"));
        }
        super(project, MembersConflictDialog.convertDescription(duplicatesConflict, dependenciesConflicts), null, true, false);
    }

    @NotNull
    private static MultiMap<PsiElement, String> convertDescription(@NotNull MultiMap<PyClass, PyMemberInfo<?>> duplicateConflictDescriptions, @NotNull Collection<PyMemberInfo<?>> dependenciesConflicts) {
        if (duplicateConflictDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicateConflictDescriptions", "com/jetbrains/python/refactoring/classes/membersManager/MembersConflictDialog", "convertDescription"));
        }
        if (dependenciesConflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesConflicts", "com/jetbrains/python/refactoring/classes/membersManager/MembersConflictDialog", "convertDescription"));
        }
        MultiMap result = new MultiMap();
        for (PyClass pyClass : duplicateConflictDescriptions.keySet()) {
            for (PyMemberInfo pyMemberInfo : duplicateConflictDescriptions.get((Object)pyClass)) {
                String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(pyClass, false), RefactoringUIUtil.getDescription(pyMemberInfo.getMember(), false)});
                result.putValue((Object)pyClass, (Object)message);
            }
        }
        for (PyMemberInfo pyMemberInfo : dependenciesConflicts) {
            result.putValue((Object)pyMemberInfo.getMember(), (Object)PyBundle.message("refactoring.will.not.be.accessible", RefactoringUIUtil.getDescription(pyMemberInfo.getMember(), false)));
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/MembersConflictDialog", "convertDescription"));
        }
        return multiMap;
    }
}

