/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.FieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class InstanceFieldsManager
extends FieldsManager {
    private static final FieldsOnly FIELDS_ONLY = new FieldsOnly();

    InstanceFieldsManager() {
        super(false);
    }

    @Override
    public boolean hasConflict(@NotNull PyTargetExpression member, @NotNull PyClass aClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "hasConflict"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "hasConflict"));
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, aClass.getInstanceAttributes());
    }

    @Override
    protected Collection<PyElement> moveAssignments(@NotNull PyClass from, @NotNull Collection<PyAssignmentStatement> statements, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "moveAssignments"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "moveAssignments"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "moveAssignments"));
        }
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        for (PyClass destClass : to) {
            result.addAll(InstanceFieldsManager.copyInstanceFields(statements, destClass));
        }
        PyFunction fromInitMethod = PyUtil.getInitMethod(from);
        if (fromInitMethod != null) {
            InstanceFieldsManager.deleteElements(Collections2.filter(statements, (Predicate)new InitsOnly(fromInitMethod)));
            PyClassRefactoringUtil.insertPassIfNeeded(fromInitMethod);
        }
        return result;
    }

    @NotNull
    private static List<PyAssignmentStatement> copyInstanceFields(@NotNull Collection<PyAssignmentStatement> members, @NotNull PyClass to) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "copyInstanceFields"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "copyInstanceFields"));
        }
        PyFunction toInitMethod = PyUtil.getInitMethod(to);
        if (toInitMethod == null) {
            toInitMethod = InstanceFieldsManager.createInitMethod(to);
        }
        PyStatementList statementList = toInitMethod.getStatementList();
        List<PyAssignmentStatement> list = PyClassRefactoringUtil.copyFieldDeclarationToStatement(members, statementList, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "copyInstanceFields"));
        }
        return list;
    }

    @NotNull
    private static PyFunction createInitMethod(@NotNull PyClass to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "createInitMethod"));
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder("__init__");
        functionBuilder.parameter("self");
        PyFunction function = functionBuilder.buildFunction(to.getProject(), LanguageLevel.forElement(to));
        PyFunction pyFunction = PyClassRefactoringUtil.addMethods(to, true, function).get(0);
        if (pyFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "createInitMethod"));
        }
        return pyFunction;
    }

    @Override
    protected boolean classHasField(@NotNull PyClass pyClass, @NotNull String fieldName) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "classHasField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "classHasField"));
        }
        return pyClass.findInstanceAttribute(fieldName, true) != null;
    }

    @Override
    @NotNull
    protected Collection<PyTargetExpression> getFieldsByClass(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "getFieldsByClass"));
        }
        Collection collection = Collections2.filter(pyClass.getInstanceAttributes(), (Predicate)FIELDS_ONLY);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager", "getFieldsByClass"));
        }
        return collection;
    }

    private static class FieldsOnly
    extends NotNullPredicate<PyTargetExpression> {
        private FieldsOnly() {
        }

        @Override
        protected boolean applyNotNull(@NotNull PyTargetExpression input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager$FieldsOnly", "applyNotNull"));
            }
            return input.getReference().resolve() instanceof PyTargetExpression;
        }
    }

    private static class InitsOnly
    extends NotNullPredicate<PyAssignmentStatement> {
        @NotNull
        private final PyFunction myInitMethod;

        private InitsOnly(@NotNull PyFunction initMethod) {
            if (initMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initMethod", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager$InitsOnly", "<init>"));
            }
            this.myInitMethod = initMethod;
        }

        @Override
        protected boolean applyNotNull(@NotNull PyAssignmentStatement input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/InstanceFieldsManager$InitsOnly", "applyNotNull"));
            }
            PyExpression expression = input.getLeftHandSideExpression();
            if (expression == null) {
                return false;
            }
            PyFunction functionWhereDeclared = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)PyUtil.resolveToTheTop((PsiElement)expression), PyFunction.class);
            return this.myInitMethod.equals(functionWhereDeclared);
        }
    }
}

