/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FieldsManager
extends MembersManager<PyTargetExpression> {
    private static final SimpleAssignmentsOnly SIMPLE_ASSIGNMENTS_ONLY = new SimpleAssignmentsOnly();
    private static final AssignmentTransform ASSIGNMENT_TRANSFORM = new AssignmentTransform();
    private final boolean myStatic;

    protected FieldsManager(boolean isStatic) {
        super(PyTargetExpression.class);
        this.myStatic = isStatic;
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedElements", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getDependencies"));
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getDependencies"));
        }
        return list;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getDependencies"));
        }
        MyPyRecursiveElementVisitor visitor = new MyPyRecursiveElementVisitor();
        member.accept(visitor);
        MultiMap<PyClass, PyElement> multiMap = visitor.myResult;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getDependencies"));
        }
        return multiMap;
    }

    @Override
    protected Collection<? extends PyElement> getElementsToStoreReferences(@NotNull Collection<PyTargetExpression> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getElementsToStoreReferences"));
        }
        return Collections2.transform(elements, (Function)ASSIGNMENT_TRANSFORM);
    }

    @Override
    @NotNull
    protected List<PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getMembersCouldBeMoved"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(this.getFieldsByClass(pyClass), (Predicate)SIMPLE_ASSIGNMENTS_ONLY));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "getMembersCouldBeMoved"));
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyTargetExpression>> members, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "moveMembers"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "moveMembers"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "moveMembers"));
        }
        return this.moveAssignments(from, Collections2.filter((Collection)Collections2.transform(FieldsManager.fetchElements(members), (Function)ASSIGNMENT_TRANSFORM), NotNullPredicate.INSTANCE), to);
    }

    protected abstract Collection<PyElement> moveAssignments(@NotNull PyClass var1, @NotNull Collection<PyAssignmentStatement> var2, PyClass ... var3);

    protected abstract boolean classHasField(@NotNull PyClass var1, @NotNull String var2);

    @NotNull
    protected abstract Collection<PyTargetExpression> getFieldsByClass(@NotNull PyClass var1);

    @Override
    @NotNull
    public PyMemberInfo<PyTargetExpression> apply(@NotNull PyTargetExpression input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "apply"));
        }
        PyMemberInfo<PyTargetExpression> pyMemberInfo = new PyMemberInfo<PyTargetExpression>(input, this.myStatic, input.getText(), this.isOverrides(input), this, false);
        if (pyMemberInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "apply"));
        }
        return pyMemberInfo;
    }

    @Nullable
    private Boolean isOverrides(@NotNull PyTargetExpression input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager", "isOverrides"));
        }
        PyClass aClass = input.getContainingClass();
        String name = input.getName();
        if (name == null) {
            return null;
        }
        assert (aClass != null) : "Target expression declared outside of class:" + input;
        return this.classHasField(aClass, name) ? Boolean.valueOf(true) : null;
    }

    private static class MyPyRecursiveElementVisitor
    extends PyRecursiveElementVisitorWithResult {
        private MyPyRecursiveElementVisitor() {
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            PyClass parent;
            PsiElement declaration = node.getReference().resolve();
            if (declaration instanceof PyElement && (parent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)declaration, PyClass.class)) != null) {
                this.myResult.putValue((Object)parent, (Object)((PyElement)declaration));
            }
        }
    }

    private static class AssignmentTransform
    implements Function<PyTargetExpression, PyAssignmentStatement> {
        private AssignmentTransform() {
        }

        @Nullable
        public PyAssignmentStatement apply(@NotNull PyTargetExpression input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager$AssignmentTransform", "apply"));
            }
            return (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)input, PyAssignmentStatement.class);
        }
    }

    private static class SimpleAssignmentsOnly
    extends NotNullPredicate<PyTargetExpression> {
        private SimpleAssignmentsOnly() {
        }

        @Override
        public boolean applyNotNull(@NotNull PyTargetExpression input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager$SimpleAssignmentsOnly", "applyNotNull"));
            }
            PsiElement parent = input.getParent();
            return parent != null && PyAssignmentStatement.class.isAssignableFrom(parent.getClass());
        }
    }
}

