/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.navigation.NavigationItem;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.FieldsManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ClassFieldsManager
extends FieldsManager {
    ClassFieldsManager() {
        super(true);
    }

    @Override
    public boolean hasConflict(@NotNull PyTargetExpression member, @NotNull PyClass aClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "hasConflict"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "hasConflict"));
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, aClass.getClassAttributes());
    }

    @Override
    protected Collection<PyElement> moveAssignments(@NotNull PyClass from, @NotNull Collection<PyAssignmentStatement> statements, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "moveAssignments"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "moveAssignments"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "moveAssignments"));
        }
        return ClassFieldsManager.moveAssignmentsImpl(from, statements, to);
    }

    static Collection<PyElement> moveAssignmentsImpl(@NotNull PyClass from, @NotNull Collection<PyAssignmentStatement> statements, PyClass ... to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "moveAssignmentsImpl"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "moveAssignmentsImpl"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "moveAssignmentsImpl"));
        }
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        for (PyClass destClass : to) {
            result.addAll(PyClassRefactoringUtil.copyFieldDeclarationToStatement(statements, destClass.getStatementList(), destClass));
        }
        ClassFieldsManager.deleteElements(statements);
        PyClassRefactoringUtil.insertPassIfNeeded(from);
        return result;
    }

    @Override
    protected boolean classHasField(@NotNull PyClass pyClass, @NotNull String fieldName) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "classHasField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "classHasField"));
        }
        return pyClass.findClassAttribute(fieldName, true) != null;
    }

    @NotNull
    protected List<PyTargetExpression> getFieldsByClass(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "getFieldsByClass"));
        }
        ImmutableList immutableList = FluentIterable.from(pyClass.getClassAttributes()).filter((Predicate)new NoMetaAndProperties(pyClass)).toList();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager", "getFieldsByClass"));
        }
        return immutableList;
    }

    private static class NoMetaAndProperties
    extends NotNullPredicate<PyTargetExpression> {
        @NotNull
        private final PyClass myClass;

        private NoMetaAndProperties(@NotNull PyClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager$NoMetaAndProperties", "<init>"));
            }
            this.myClass = aClass;
        }

        @Override
        public boolean applyNotNull(@NotNull PyTargetExpression input) {
            PyExpression callee;
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/ClassFieldsManager$NoMetaAndProperties", "applyNotNull"));
            }
            String name = input.getName();
            if (name == null) {
                return false;
            }
            if (name.equals("__metaclass__")) {
                return false;
            }
            PyExpression assignedValue = input.findAssignedValue();
            return !(assignedValue instanceof PyCallExpression) || (callee = ((PyCallExpression)assignedValue).getCallee()) == null || !"property".equals(callee.getName()) || this.myClass.findProperty(name, false) == null;
        }
    }
}

