/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.extractSuperclass;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.refactoring.RefactoringBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHandler;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassInitializationInfo;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassPresenter;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassView;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedViewSwingImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class PyExtractSuperclassViewSwingImpl
extends MembersBasedViewSwingImpl<PyExtractSuperclassPresenter, PyExtractSuperclassInitializationInfo>
implements PyExtractSuperclassView {
    private static final String FILE_OR_DIRECTORY = RefactoringBundle.message((String)"extract.superclass.elements.header");
    @NotNull
    private final JTextArea myExtractedSuperNameField;
    @NotNull
    private final FileChooserDescriptor myFileChooserDescriptor;
    @NotNull
    private final TextFieldWithBrowseButton myTargetDirField;

    PyExtractSuperclassViewSwingImpl(@NotNull PyClass classUnderRefactoring, @NotNull Project project, @NotNull PyExtractSuperclassPresenter presenter) {
        if (classUnderRefactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classUnderRefactoring", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassViewSwingImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassViewSwingImpl", "<init>"));
        }
        if (presenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presenter", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassViewSwingImpl", "<init>"));
        }
        super(project, presenter, RefactoringBundle.message((String)"extract.superclass.from"), true);
        this.myExtractedSuperNameField = new JTextArea();
        this.setTitle(PyExtractSuperclassHandler.REFACTORING_NAME);
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"extract.superclass.from")), "North");
        JTextField sourceClassField = new JTextField();
        sourceClassField.setEditable(false);
        sourceClassField.setText(classUnderRefactoring.getName());
        panel.add((Component)sourceClassField, "Center");
        box.add(panel);
        box.add(Box.createVerticalStrut(10));
        JLabel superNameLabel = new JLabel();
        superNameLabel.setText(RefactoringBundle.message((String)"superclass.name"));
        panel = new JPanel(new BorderLayout());
        panel.add((Component)superNameLabel, "North");
        panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(panel);
        box.add(Box.createVerticalStrut(5));
        this.myFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        this.myFileChooserDescriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        this.myFileChooserDescriptor.withTreeRootVisible(true);
        this.myTargetDirField = new TextFieldWithBrowseButton();
        this.myTargetDirField.addBrowseFolderListener(FILE_OR_DIRECTORY, null, project, this.myFileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        panel = new JPanel(new BorderLayout());
        JLabel dirLabel = new JLabel();
        dirLabel.setText(FILE_OR_DIRECTORY);
        panel.add((Component)dirLabel, "North");
        panel.add((Component)this.myTargetDirField, "Center");
        box.add(panel);
        box.add(Box.createVerticalStrut(10));
        this.myTopPanel.add((Component)box, "Center");
        this.myCenterPanel.add((Component)this.myPyMemberSelectionPanel, "Center");
        this.setPreviewResults(false);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    @Override
    public void configure(@NotNull PyExtractSuperclassInitializationInfo configInfo) {
        if (configInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configInfo", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassViewSwingImpl", "configure"));
        }
        super.configure(configInfo);
        this.myFileChooserDescriptor.setRoots(configInfo.getRoots());
        this.myTargetDirField.setText(configInfo.getDefaultFilePath());
    }

    @Override
    @NotNull
    public String getModuleFile() {
        String string = this.myTargetDirField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassViewSwingImpl", "getModuleFile"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuperClassName() {
        String string = this.myExtractedSuperNameField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassViewSwingImpl", "getSuperClassName"));
        }
        return string;
    }
}

