/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.extractSuperclass;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHelper;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassInfoModel;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassInitializationInfo;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassPresenter;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassView;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.vp.BadDataException;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenterNoPreviewImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PyExtractSuperclassPresenterImpl
extends MembersBasedPresenterNoPreviewImpl<PyExtractSuperclassView, MemberInfoModel<PyElement, PyMemberInfo<PyElement>>>
implements PyExtractSuperclassPresenter {
    private final NamesValidator myNamesValidator;

    PyExtractSuperclassPresenterImpl(@NotNull PyExtractSuperclassView view, @NotNull PyClass classUnderRefactoring, @NotNull PyMemberInfoStorage infoStorage) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl", "<init>"));
        }
        if (classUnderRefactoring == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classUnderRefactoring", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl", "<init>"));
        }
        if (infoStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoStorage", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl", "<init>"));
        }
        super(view, classUnderRefactoring, infoStorage, new PyExtractSuperclassInfoModel(classUnderRefactoring));
        this.myNamesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
    }

    @Override
    protected void validateView() throws BadDataException {
        PsiFile psiFile;
        super.validateView();
        Project project = this.myClassUnderRefactoring.getProject();
        if (!this.myNamesValidator.isIdentifier(((PyExtractSuperclassView)this.myView).getSuperClassName(), project)) {
            throw new BadDataException(PyBundle.message("refactoring.extract.super.name.0.must.be.ident", ((PyExtractSuperclassView)this.myView).getSuperClassName()));
        }
        boolean rootFound = false;
        File moduleFile = new File(((PyExtractSuperclassView)this.myView).getModuleFile());
        try {
            String targetDir = FileUtil.toSystemIndependentName((String)moduleFile.getCanonicalPath());
            for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                if (!StringUtil.startsWithIgnoreCase((String)targetDir, (String)file.getPath())) continue;
                rootFound = true;
                break;
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (!rootFound) {
            throw new BadDataException(PyBundle.message("refactoring.extract.super.target.path.outside.roots", new Object[0]));
        }
        ((PyExtractSuperclassView)this.myView).getModuleFile();
        VirtualFile moduleVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(moduleFile);
        if (moduleVirtualFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(moduleVirtualFile)) instanceof PyFile && ((PyFile)psiFile).findTopLevelClass(((PyExtractSuperclassView)this.myView).getSuperClassName()) != null) {
            throw new BadDataException(PyBundle.message("refactoring.extract.super.target.class.already.exists", ((PyExtractSuperclassView)this.myView).getSuperClassName()));
        }
    }

    @Override
    public void launch() {
        String defaultFilePath = FileUtil.toSystemDependentName((String)this.myClassUnderRefactoring.getContainingFile().getVirtualFile().getPath());
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myClassUnderRefactoring.getProject()).getContentRoots();
        Collection<PyMemberInfo<PyElement>> pyMemberInfos = PyUtil.filterOutObject(this.myStorage.getClassMemberInfos(this.myClassUnderRefactoring));
        ((PyExtractSuperclassView)this.myView).configure(new PyExtractSuperclassInitializationInfo((MemberInfoModel<PyElement, PyMemberInfo<PyElement>>)this.myModel, pyMemberInfos, defaultFilePath, roots));
        ((PyExtractSuperclassView)this.myView).initAndShow();
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{((PyExtractSuperclassView)this.myView).getSuperClassName(), this.myClassUnderRefactoring.getName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl", "getCommandName"));
        }
        return string;
    }

    @Override
    protected void refactorNoPreview() {
        PyExtractSuperclassHelper.extractSuperclass(this.myClassUnderRefactoring, ((PyExtractSuperclassView)this.myView).getSelectedMemberInfos(), ((PyExtractSuperclassView)this.myView).getSuperClassName(), ((PyExtractSuperclassView)this.myView).getModuleFile());
    }

    @Override
    @NotNull
    protected Iterable<? extends PyClass> getDestClassesToCheckConflicts() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl", "getDestClassesToCheckConflicts"));
        }
        return list;
    }
}

