/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.extractSuperclass;

import com.google.common.base.Predicate;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.FluentIterable;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyExtractSuperclassHelper {
    private static final Logger LOG = Logger.getInstance((String)PyExtractSuperclassHelper.class.getName());
    private static final Predicate<PyMemberInfo<PyElement>> ALLOW_OBJECT = new PyUtil.ObjectPredicate(true);

    private PyExtractSuperclassHelper() {
    }

    static void extractSuperclass(PyClass clazz, @NotNull Collection<PyMemberInfo<PyElement>> selectedMemberInfos, String superBaseName, String targetFile) {
        PyMemberInfo<PyElement> object;
        if (selectedMemberInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedMemberInfos", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassHelper", "extractSuperclass"));
        }
        Project project = clazz.getProject();
        selectedMemberInfos = new ArrayList<PyMemberInfo<PyElement>>(selectedMemberInfos);
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements((Collection)FluentIterable.from(selectedMemberInfos).transform((Function)new Function<PyMemberInfo<PyElement>, PsiElement>(){

            public PsiElement fun(PyMemberInfo<PyElement> info) {
                return info.getMember();
            }
        }).toList());
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractSuperclassHelper.getRefactoringId(), beforeData);
        PyMemberInfo<PyElement> objectMember = MembersManager.findMember(selectedMemberInfos, ALLOW_OBJECT);
        if (LanguageLevel.forElement(clazz).isPy3K()) {
            if (objectMember != null) {
                selectedMemberInfos.remove(objectMember);
            }
        } else if (objectMember == null && (object = MembersManager.findMember(clazz, ALLOW_OBJECT)) != null) {
            selectedMemberInfos.add(object);
        }
        String text = "class " + superBaseName + ":\n  pass" + "\n";
        PyClass newClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyClass.class, text);
        newClass = PyExtractSuperclassHelper.placeNewClass(project, newClass, clazz, targetFile);
        MembersManager.moveAllMembers(selectedMemberInfos, clazz, newClass);
        if (!newClass.getContainingFile().equals(clazz.getContainingFile())) {
            PyClassRefactoringUtil.optimizeImports(clazz.getContainingFile());
        }
        PyClassRefactoringUtil.addSuperclasses(project, clazz, null, newClass);
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement((PsiElement)newClass);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractSuperclassHelper.getRefactoringId(), afterData);
    }

    private static PyClass placeNewClass(Project project, PyClass newClass, @NotNull PyClass clazz, String targetFile) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassHelper", "placeNewClass"));
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(ApplicationManagerEx.getApplicationEx().isUnitTestMode() ? targetFile : VfsUtilCore.pathToUrl((String)targetFile));
        if (Comparing.equal((Object)file, (Object)clazz.getContainingFile().getVirtualFile())) {
            return (PyClass)clazz.getParent().addBefore((PsiElement)newClass, (PsiElement)clazz);
        }
        PsiFile psiFile = null;
        try {
            if (file == null) {
                String filename;
                String path;
                if (targetFile.endsWith(PythonFileType.INSTANCE.getDefaultExtension())) {
                    path = PathUtil.getParentPath((String)targetFile);
                    filename = PathUtil.getFileName((String)targetFile);
                } else {
                    path = targetFile;
                    filename = "__init__.py";
                }
                psiFile = PyExtractSuperclassHelper.placeFile(project, path, filename);
            } else {
                psiFile = file.isDirectory() ? PyExtractSuperclassHelper.placeFile(project, file.getPath(), "__init__.py") : PsiManager.getInstance((Project)project).findFile(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        LOG.assertTrue(psiFile != null);
        if (psiFile.getLastChild() != null) {
            psiFile.add((PsiElement)PyElementGenerator.getInstance(project).createFromText(LanguageLevel.PYTHON24, PsiWhiteSpace.class, "\n\n"));
        }
        newClass = (PyClass)psiFile.add((PsiElement)newClass);
        PyClassRefactoringUtil.insertImport((PsiElement)clazz, Collections.singleton(newClass));
        return newClass;
    }

    public static PsiFile placeFile(Project project, String path, String filename) throws IOException {
        return PyExtractSuperclassHelper.placeFile(project, path, filename, null);
    }

    public static PsiFile placeFile(Project project, String path, String filename, @Nullable String content) throws IOException {
        PsiDirectory psiDir = PyExtractSuperclassHelper.createDirectories(project, path);
        LOG.assertTrue(psiDir != null);
        PsiFile psiFile = psiDir.findFile(filename);
        if (psiFile == null) {
            PsiDocumentManager manager;
            Document document;
            psiFile = psiDir.createFile(filename);
            if (content != null && (document = (manager = PsiDocumentManager.getInstance((Project)project)).getDocument(psiFile)) != null) {
                document.setText((CharSequence)content);
                manager.commitDocument(document);
            }
        }
        return psiFile;
    }

    @Nullable
    private static PsiDirectory createDirectories(Project project, String target) throws IOException {
        String the_rest = null;
        VirtualFile the_root = null;
        PsiDirectory ret = null;
        target = FileUtil.toSystemIndependentName((String)target);
        for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            String root_path = file.getPath();
            if (!target.startsWith(root_path)) continue;
            the_rest = target.substring(root_path.length());
            the_root = file;
            break;
        }
        if (the_root == null) {
            throw new IOException("Can't find '" + target + "' among roots");
        }
        if (the_rest != null) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            PsiManager psi_mgr = PsiManager.getInstance((Project)project);
            String[] dirs = the_rest.split("/");
            int i = 0;
            if ("".equals(dirs[0])) {
                i = 1;
            }
            while (i < dirs.length) {
                VirtualFile init_vfile;
                VirtualFile subdir = the_root.findChild(dirs[i]);
                if (subdir != null) {
                    if (!subdir.isDirectory()) {
                        throw new IOException("Expected dir, but got non-dir: " + subdir.getPath());
                    }
                } else {
                    subdir = the_root.createChildDirectory((Object)lfs, dirs[i]);
                }
                if ((init_vfile = subdir.findChild("__init__.py")) == null) {
                    init_vfile = subdir.createChildData((Object)lfs, "__init__.py");
                }
                the_root = subdir;
                ++i;
            }
            ret = psi_mgr.findDirectory(the_root);
        }
        return ret;
    }

    public static String getRefactoringId() {
        return "refactoring.python.extract.superclass";
    }
}

