/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.classes.DependencyVisitor;
import java.io.Serializable;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PyDependenciesComparator
implements Comparator<PyElement>,
Serializable {
    public static final PyDependenciesComparator INSTANCE = new PyDependenciesComparator();

    private PyDependenciesComparator() {
    }

    @Override
    public int compare(@NotNull PyElement o1, @NotNull PyElement o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "compare"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "compare"));
        }
        if (PyDependenciesComparator.depends(o1, o2)) {
            return 1;
        }
        if (PyDependenciesComparator.depends(o2, o1)) {
            return -1;
        }
        return PyDependenciesComparator.getBlockType(o1).compareTo(PyDependenciesComparator.getBlockType(o2));
    }

    @NotNull
    private static BlockType getBlockType(@NotNull PyElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "getBlockType"));
        }
        for (BlockType type : BlockType.values()) {
            if (!type.myClass.isAssignableFrom(statement.getClass())) continue;
            BlockType blockType = type;
            if (blockType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "getBlockType"));
            }
            return blockType;
        }
        BlockType blockType = BlockType.OTHER;
        if (blockType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "getBlockType"));
        }
        return blockType;
    }

    public static boolean depends(@NotNull PyElement o1, @NotNull PyElement o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "depends"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator", "depends"));
        }
        DependencyVisitor visitor = new DependencyVisitor(o2);
        o1.accept(visitor);
        return visitor.isDependencyFound();
    }

    private static enum BlockType {
        DOC(PyExpressionStatement.class),
        DECLARATION(PyAssignmentStatement.class),
        METHOD(PyFunction.class),
        OTHER(PyElement.class);

        @NotNull
        private final Class<? extends PyElement> myClass;

        private BlockType(Class<? extends PyElement> aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator$BlockType", "<init>"));
            }
            this.myClass = aClass;
        }
    }
}

