/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.google.common.collect.Collections2;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyClassRefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)PyClassRefactoringUtil.class.getName());
    private static final Key<PsiNamedElement> ENCODED_IMPORT = Key.create((String)"PyEncodedImport");
    private static final Key<Boolean> ENCODED_USE_FROM_IMPORT = Key.create((String)"PyEncodedUseFromImport");
    private static final Key<String> ENCODED_IMPORT_AS = Key.create((String)"PyEncodedImportAs");

    private PyClassRefactoringUtil() {
    }

    @NotNull
    public static List<PyAssignmentStatement> copyFieldDeclarationToStatement(@NotNull Collection<PyAssignmentStatement> assignmentStatements, @NotNull PyStatementList superClassStatement, @Nullable PyClass dequalifyIfDeclaredInClass) {
        if (assignmentStatements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentStatements", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "copyFieldDeclarationToStatement"));
        }
        if (superClassStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassStatement", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "copyFieldDeclarationToStatement"));
        }
        ArrayList<PyAssignmentStatement> declarations = new ArrayList<PyAssignmentStatement>(assignmentStatements.size());
        Collections.sort(declarations, PyDependenciesComparator.INSTANCE);
        for (PyAssignmentStatement pyAssignmentStatement : assignmentStatements) {
            PyExpression value = pyAssignmentStatement.getAssignedValue();
            PyAssignmentStatement newDeclaration = (PyAssignmentStatement)pyAssignmentStatement.copy();
            if (value instanceof PyReferenceExpression && dequalifyIfDeclaredInClass != null) {
                String newValue = PyClassRefactoringUtil.getNewValueToAssign((PyReferenceExpression)value, dequalifyIfDeclaredInClass);
                PyClassRefactoringUtil.setNewAssigneeValue(newDeclaration, newValue);
            }
            declarations.add(PyUtil.addElementToStatementList(newDeclaration, superClassStatement));
            PyPsiUtils.removeRedundantPass(superClassStatement);
        }
        ArrayList<PyAssignmentStatement> arrayList = declarations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "copyFieldDeclarationToStatement"));
        }
        return arrayList;
    }

    private static void setNewAssigneeValue(@NotNull PyAssignmentStatement assignmentStatement, @NotNull String newValue) {
        if (assignmentStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentStatement", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "setNewAssigneeValue"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "setNewAssigneeValue"));
        }
        PyExpression oldValue = assignmentStatement.getAssignedValue();
        PyExpression newExpression = PyElementGenerator.getInstance(assignmentStatement.getProject()).createExpressionFromText(LanguageLevel.forElement(assignmentStatement), newValue);
        if (oldValue != null) {
            oldValue.replace((PsiElement)newExpression);
        } else {
            assignmentStatement.add((PsiElement)newExpression);
        }
    }

    @NotNull
    private static String getNewValueToAssign(@NotNull PyReferenceExpression currentValue, @NotNull PyClass dequalifyIfDeclaredInClass) {
        if (currentValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "getNewValueToAssign"));
        }
        if (dequalifyIfDeclaredInClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dequalifyIfDeclaredInClass", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "getNewValueToAssign"));
        }
        PyExpression qualifier = currentValue.getQualifier();
        if (qualifier instanceof PyReferenceExpression && ((PyReferenceExpression)qualifier).getReference().isReferenceTo((PsiElement)dequalifyIfDeclaredInClass)) {
            String name = currentValue.getName();
            String string = name != null ? name : currentValue.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "getNewValueToAssign"));
            }
            return string;
        }
        String string = currentValue.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "getNewValueToAssign"));
        }
        return string;
    }

    @NotNull
    public static List<PyFunction> copyMethods(Collection<PyFunction> methods, PyClass superClass, boolean skipIfExist) {
        if (methods.isEmpty()) {
            List<PyFunction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "copyMethods"));
            }
            return list;
        }
        for (PyFunction e : methods) {
            PyClassRefactoringUtil.rememberNamedReferences(e, new String[0]);
        }
        PyFunction[] elements = methods.toArray(new PyFunction[methods.size()]);
        List<PyFunction> list = PyClassRefactoringUtil.addMethods(superClass, skipIfExist, elements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "copyMethods"));
        }
        return list;
    }

    @NotNull
    public static List<PyFunction> addMethods(@NotNull PyClass destination, boolean skipIfExist, PyFunction ... methods) {
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addMethods"));
        }
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addMethods"));
        }
        PyStatementList destStatementList = destination.getStatementList();
        ArrayList<PyFunction> result = new ArrayList<PyFunction>(methods.length);
        for (PyFunction method : methods) {
            PyFunction existingMethod = destination.findMethodByName(method.getName(), false);
            if (existingMethod != null && skipIfExist) {
                result.add(existingMethod);
                continue;
            }
            PyFunction newMethod = PyClassRefactoringUtil.insertMethodInProperPlace(destStatementList, method);
            result.add(newMethod);
            PyClassRefactoringUtil.restoreNamedReferences(newMethod);
        }
        PyPsiUtils.removeRedundantPass(destStatementList);
        ArrayList<PyFunction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addMethods"));
        }
        return arrayList;
    }

    @NotNull
    private static PyFunction insertMethodInProperPlace(@NotNull PyStatementList destStatementList, @NotNull PyFunction method) {
        if (destStatementList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destStatementList", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertMethodInProperPlace"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertMethodInProperPlace"));
        }
        boolean methodIsInit = PyUtil.isInit(method);
        if (!methodIsInit) {
            PyFunction pyFunction = (PyFunction)destStatementList.add(method);
            if (pyFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertMethodInProperPlace"));
            }
            return pyFunction;
        }
        for (PsiElement element : destStatementList.getChildren()) {
            boolean elementComment = element instanceof PyExpressionStatement;
            boolean elementClassField = element instanceof PyAssignmentStatement;
            if (elementComment || elementClassField) continue;
            PyFunction pyFunction = (PyFunction)destStatementList.addBefore(method, element);
            if (pyFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertMethodInProperPlace"));
            }
            return pyFunction;
        }
        PyFunction pyFunction = (PyFunction)destStatementList.add(method);
        if (pyFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertMethodInProperPlace"));
        }
        return pyFunction;
    }

    public static <T extends PyElement & PyStatementListContainer> void insertPassIfNeeded(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertPassIfNeeded"));
        }
        PyStatementList statements = ((PyStatementListContainer)element).getStatementList();
        if (statements.getStatements().length == 0) {
            statements.add((PsiElement)PyElementGenerator.getInstance(element.getProject()).createFromText(LanguageLevel.getDefault(), PyPassStatement.class, "pass"));
        }
    }

    public static void restoreNamedReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "restoreNamedReferences"));
        }
        PyClassRefactoringUtil.restoreNamedReferences(element, null);
    }

    public static void restoreNamedReferences(final @NotNull PsiElement newElement, final @Nullable PsiElement oldElement) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "restoreNamedReferences"));
        }
        newElement.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                PyClassRefactoringUtil.restoreReference(node);
            }

            @Override
            public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
                super.visitPyStringLiteralExpression(node);
                for (PsiReference ref : node.getReferences()) {
                    if (!ref.isReferenceTo(oldElement)) continue;
                    ref.bindToElement(newElement);
                }
            }
        });
    }

    private static void restoreReference(PyReferenceExpression node) {
        PyFunction f;
        PyClass c;
        Object target = (PsiNamedElement)node.getCopyableUserData(ENCODED_IMPORT);
        String asName = (String)node.getCopyableUserData(ENCODED_IMPORT_AS);
        Boolean useFromImport = (Boolean)node.getCopyableUserData(ENCODED_USE_FROM_IMPORT);
        if (target instanceof PsiDirectory) {
            target = (PsiNamedElement)PyUtil.turnDirIntoPackageElement((PsiDirectory)target, (PsiElement)node);
        }
        if (target instanceof PyFunction && (c = (f = (PyFunction)target).getContainingClass()) != null && c.findInitOrNew(false) == f) {
            target = c;
        }
        if (target == null) {
            return;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)node.getContainingFile(), (PsiElement)target, (boolean)false)) {
            return;
        }
        if (target instanceof PyFile || target instanceof PsiDirectory) {
            PyClassRefactoringUtil.insertImport((PsiElement)node, target, asName, useFromImport != null ? useFromImport : true);
        } else {
            PyClassRefactoringUtil.insertImport((PsiElement)node, target, asName, true);
        }
        node.putCopyableUserData(ENCODED_IMPORT, null);
        node.putCopyableUserData(ENCODED_IMPORT_AS, null);
        node.putCopyableUserData(ENCODED_USE_FROM_IMPORT, null);
    }

    public static void insertImport(PsiElement anchor, Collection<PsiNamedElement> elements) {
        for (PsiNamedElement newClass : elements) {
            PyClassRefactoringUtil.insertImport(anchor, newClass);
        }
    }

    public static boolean isValidQualifiedName(QualifiedName name) {
        if (name == null) {
            return false;
        }
        List components = name.getComponents();
        if (components.isEmpty()) {
            return false;
        }
        for (String s : components) {
            if (PyNames.isIdentifier(s) && !PyNames.isReserved(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertImport"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertImport"));
        }
        return PyClassRefactoringUtil.insertImport(anchor, element, null);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertImport"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertImport"));
        }
        return PyClassRefactoringUtil.insertImport(anchor, element, asName, PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT);
    }

    public static boolean insertImport(@NotNull PsiElement anchor, @NotNull PsiNamedElement element, @Nullable String asName, boolean preferFromImport) {
        String importedName;
        QualifiedName containingQName;
        PsiFile file;
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertImport"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "insertImport"));
        }
        if (PyBuiltinCache.getInstance((PsiElement)element).isBuiltin((PsiElement)element)) {
            return false;
        }
        Object elementSource = element instanceof PsiDirectory ? (PsiFileSystemItem)element : element.getContainingFile();
        if (elementSource == (file = anchor.getContainingFile())) {
            return false;
        }
        QualifiedName qname = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, anchor);
        if (qname == null || !PyClassRefactoringUtil.isValidQualifiedName(qname)) {
            return false;
        }
        if (element instanceof PyFile || element instanceof PsiDirectory) {
            containingQName = qname.removeLastComponent();
            importedName = qname.getLastComponent();
        } else {
            containingQName = qname;
            importedName = PyClassRefactoringUtil.getOriginalName(element);
        }
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority(anchor, elementSource);
        if (preferFromImport && !containingQName.getComponents().isEmpty()) {
            return AddImportHelper.addOrUpdateFromImportStatement(file, containingQName.toString(), importedName, asName, priority, anchor);
        }
        return AddImportHelper.addImportStatement(file, containingQName.append(importedName).toString(), asName, priority, anchor);
    }

    public static void rememberNamedReferences(final @NotNull PsiElement element, final String ... namesToSkip) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "rememberNamedReferences"));
        }
        if (namesToSkip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesToSkip", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "rememberNamedReferences"));
        }
        element.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                    return;
                }
                NameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
                if (importElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)importElement, (boolean)false)) {
                    return;
                }
                if (!ArrayUtil.contains((String)node.getText(), (String[])namesToSkip)) {
                    PyClassRefactoringUtil.rememberReference(node, element);
                }
            }
        });
    }

    private static void rememberReference(@NotNull PyReferenceExpression node, @NotNull PsiElement element) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "rememberReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "rememberReference"));
        }
        PyExpression qualifier = node.getQualifier();
        if (qualifier != null && !(PyClassRefactoringUtil.resolveExpression(qualifier) instanceof PyImportedModule)) {
            return;
        }
        PsiElement target = PyClassRefactoringUtil.resolveExpression(node);
        if (target instanceof PsiNamedElement && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)target, (boolean)false)) {
            NameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
            if (!PyUtil.inSameFile(element, target) && importElement == null && !(target instanceof PsiFileSystemItem)) {
                return;
            }
            node.putCopyableUserData(ENCODED_IMPORT, (PsiNamedElement)target);
            if (importElement instanceof PyImportElement) {
                node.putCopyableUserData(ENCODED_IMPORT_AS, ((PyImportElement)importElement).getAsName());
            }
            node.putCopyableUserData(ENCODED_USE_FROM_IMPORT, qualifier == null);
        }
    }

    @Nullable
    private static NameDefiner getImportElement(PyReferenceExpression expr) {
        for (ResolveResult result : expr.getReference().multiResolve(false)) {
            PsiElement e = result.getElement();
            if (e instanceof PyImportElement) {
                return (PyImportElement)e;
            }
            if (!(e instanceof PyStarImportElement)) continue;
            return (PyStarImportElement)e;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull PyExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "resolveExpression"));
        }
        if (expr instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)expr).getReference().resolve();
        }
        return null;
    }

    public static void updateImportOfElement(@NotNull PyImportStatementBase importStatement, @NotNull PsiNamedElement element) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "updateImportOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "updateImportOfElement"));
        }
        String name = PyClassRefactoringUtil.getOriginalName(element);
        if (name != null) {
            PyImportElement importElement = null;
            for (PyImportElement e : importStatement.getImportElements()) {
                if (!name.equals(PyClassRefactoringUtil.getOriginalName(e))) continue;
                importElement = e;
            }
            if (importElement != null) {
                PsiFile file = importStatement.getContainingFile();
                PsiFile newFile = element.getContainingFile();
                boolean deleteImportElement = false;
                if (newFile == file) {
                    deleteImportElement = true;
                } else if (PyClassRefactoringUtil.insertImport((PsiElement)importStatement, element, importElement.getAsName(), true)) {
                    deleteImportElement = true;
                }
                if (deleteImportElement) {
                    if (importStatement.getImportElements().length == 1) {
                        boolean isInjected = InjectedLanguageManager.getInstance((Project)importElement.getProject()).isInjectedFragment(importElement.getContainingFile());
                        if (!isInjected) {
                            importStatement.delete();
                        } else {
                            PyClassRefactoringUtil.deleteImportStatementFromInjected(importStatement);
                        }
                    } else {
                        importElement.delete();
                    }
                }
            }
        }
    }

    private static void deleteImportStatementFromInjected(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "deleteImportStatementFromInjected"));
        }
        PsiElement sibling = importStatement.getPrevSibling();
        importStatement.delete();
        if (sibling instanceof PsiWhiteSpace) {
            sibling.delete();
        }
    }

    @Nullable
    public static String getOriginalName(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "getOriginalName"));
        }
        if (element instanceof PyFile) {
            VirtualFile virtualFile = PsiUtilBase.asVirtualFile((PsiElement)PyUtil.turnInitIntoDir((PsiElement)element));
            if (virtualFile != null) {
                return virtualFile.getNameWithoutExtension();
            }
            return null;
        }
        return element.getName();
    }

    @Nullable
    private static String getOriginalName(PyImportElement element) {
        QualifiedName qname = element.getImportedQName();
        if (qname != null && qname.getComponentCount() > 0) {
            return (String)qname.getComponents().get(0);
        }
        return null;
    }

    public static void addSuperclasses(@NotNull Project project, @NotNull PyClass clazz, PyClass ... superClasses) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addSuperclasses"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addSuperclasses"));
        }
        if (superClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClasses", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addSuperclasses"));
        }
        ArrayList<String> superClassNames = new ArrayList<String>();
        for (PyClass superClass : Collections2.filter(Arrays.asList(superClasses), NotNullPredicate.INSTANCE)) {
            if (superClass.getName() == null) continue;
            superClassNames.add(superClass.getName());
            PyClassRefactoringUtil.insertImport((PsiElement)clazz, (PsiNamedElement)superClass);
        }
        PyClassRefactoringUtil.addSuperClassExpressions(project, clazz, superClassNames, null);
    }

    public static void addSuperClassExpressions(@NotNull Project project, @NotNull PyClass clazz, @Nullable Collection<String> paramExpressions, @Nullable Collection<Pair<String, String>> keywordArguments) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addSuperClassExpressions"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addSuperClassExpressions"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        LanguageLevel languageLevel = LanguageLevel.forElement(clazz);
        PyArgumentList superClassExpressionList = clazz.getSuperClassExpressionList();
        boolean addExpression = false;
        if (superClassExpressionList == null) {
            superClassExpressionList = generator.createFromText(languageLevel, PyClass.class, "class foo():pass").getSuperClassExpressionList();
            assert (superClassExpressionList != null) : "expression not created";
            addExpression = true;
        }
        generator.createFromText(LanguageLevel.PYTHON34, PyClass.class, "class foo(object, metaclass=Foo): pass").getSuperClassExpressionList();
        if (paramExpressions != null) {
            for (String string : paramExpressions) {
                superClassExpressionList.addArgument(generator.createParameter(string));
            }
        }
        if (keywordArguments != null) {
            for (Pair pair : keywordArguments) {
                superClassExpressionList.addArgument(generator.createKeywordArgument(languageLevel, (String)pair.first, (String)pair.second));
            }
        }
        if (addExpression) {
            ASTNode classNameNode = clazz.getNameNode();
            PsiElement psiElement = classNameNode == null ? clazz.getFirstChild() : classNameNode.getPsi();
            clazz.addAfter((PsiElement)superClassExpressionList, psiElement);
        }
    }

    public static void optimizeImports(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "optimizeImports"));
        }
        new PyImportOptimizer().processFile(file).run();
    }

    @Nullable
    public static PsiElement addClassAttributeIfNotExist(@NotNull PyClass aClass, @NotNull String attributeName, @NotNull String value) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addClassAttributeIfNotExist"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addClassAttributeIfNotExist"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil", "addClassAttributeIfNotExist"));
        }
        if (aClass.findClassAttribute(attributeName, false) != null) {
            return null;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(aClass.getProject());
        String text = String.format("%s = %s", attributeName, value);
        LanguageLevel level = LanguageLevel.forElement(aClass);
        PyAssignmentStatement assignmentStatement = generator.createFromText(level, PyAssignmentStatement.class, text);
        return PyUtil.addElementToStatementList(assignmentStatement, aClass.getStatementList(), true);
    }
}

