/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import org.jetbrains.annotations.NotNull;

class DependencyVisitor
extends PyRecursiveElementVisitor {
    @NotNull
    private final PyElement myElementToFind;
    private boolean myDependencyFound;

    DependencyVisitor(@NotNull PyElement elementToFind) {
        if (elementToFind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToFind", "com/jetbrains/python/refactoring/classes/DependencyVisitor", "<init>"));
        }
        this.myElementToFind = elementToFind;
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/classes/DependencyVisitor", "visitPyCallExpression"));
        }
        PyExpression callee = node.getCallee();
        if (callee != null) {
            PyArgumentList list;
            PsiReference calleeReference = callee.getReference();
            if (calleeReference != null && calleeReference.isReferenceTo((PsiElement)this.myElementToFind)) {
                this.myDependencyFound = true;
                return;
            }
            String calleeName = callee.getName();
            String name = this.myElementToFind.getName();
            if (calleeName != null && calleeName.equals(name)) {
                this.myDependencyFound = true;
            }
            if ((list = node.getArgumentList()) != null) {
                for (PyExpression expression : node.getArgumentList().getArgumentExpressions()) {
                    PsiReference reference = expression.getReference();
                    if (reference != null && reference.isReferenceTo((PsiElement)this.myElementToFind)) {
                        this.myDependencyFound = true;
                    }
                    if (name == null || !name.equals(expression.getName())) continue;
                    this.myDependencyFound = true;
                }
            }
        }
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        PsiPolyVariantReference reference = node.getReference();
        if (reference.isReferenceTo((PsiElement)this.myElementToFind)) {
            this.myDependencyFound = true;
            return;
        }
        if (this.myElementToFind instanceof PyAssignmentStatement) {
            PyExpression[] targets = ((PyAssignmentStatement)this.myElementToFind).getTargets();
            if (targets.length != 1) {
                return;
            }
            PyExpression expression = targets[0];
            if (reference.isReferenceTo((PsiElement)expression)) {
                this.myDependencyFound = true;
                return;
            }
            if (node.getText().equals(expression.getText())) {
                this.myDependencyFound = true;
            }
            return;
        }
        PsiElement declaration = reference.resolve();
        this.myDependencyFound = PsiTreeUtil.findFirstParent((PsiElement)declaration, (Condition)new PsiElementCondition()) != null;
    }

    public boolean isDependencyFound() {
        return this.myDependencyFound;
    }

    private class PsiElementCondition
    implements Condition<PsiElement> {
        private PsiElementCondition() {
        }

        public boolean value(PsiElement psiElement) {
            return psiElement.equals(DependencyVisitor.this.myElementToFind);
        }
    }
}

