/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.documentation.PyDocstringGenerator;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.editor.PythonDocCommentUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.changeSignature.PyChangeInfo;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private boolean useKeywords = false;
    private boolean isMethod = false;
    private boolean isAfterStar = false;

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (info instanceof PyChangeInfo) {
            List<UsageInfo> usages = PyRefactoringUtil.findUsages(((PyChangeInfo)info).getMethod(), true);
            Query<PyFunction> search = PyOverridingMethodsSearch.search(((PyChangeInfo)info).getMethod(), true);
            Collection functions = search.findAll();
            for (PyFunction function : functions) {
                usages.add(new UsageInfo((PsiElement)function));
                usages.addAll(PyRefactoringUtil.findUsages(function, true));
            }
            return usages.toArray(new UsageInfo[usages.size()]);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    @Nullable
    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        PyFunction function;
        PyClass clazz;
        MultiMap conflicts = new MultiMap();
        if (info instanceof PyChangeInfo && info.isNameChanged() && (clazz = (function = ((PyChangeInfo)info).getMethod()).getContainingClass()) != null && clazz.findMethodByName(info.getNewName(), true) != null) {
            conflicts.putValue((Object)function, (Object)RefactoringBundle.message((String)"method.0.is.already.defined.in.the.1", (Object[])new Object[]{info.getNewName(), "class " + clazz.getQualifiedName()}));
        }
        return conflicts;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!PyChangeSignatureUsageProcessor.isPythonUsage(usageInfo)) {
            return false;
        }
        if (!(changeInfo instanceof PyChangeInfo)) {
            return false;
        }
        if (!beforeMethodChange) {
            return false;
        }
        PsiElement element = usageInfo.getElement();
        if (changeInfo.isNameChanged()) {
            PsiElement method = changeInfo.getMethod();
            RenameUtil.doRenameGenericNamedElement(method, changeInfo.getNewName(), usages, null);
        }
        if (element == null) {
            return false;
        }
        if (element.getParent() instanceof PyCallExpression) {
            PyCallExpression call = (PyCallExpression)element.getParent();
            PyArgumentList argumentList = call.getArgumentList();
            if (argumentList != null) {
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(element.getProject());
                StringBuilder builder = this.buildSignature((PyChangeInfo)changeInfo, call);
                PyExpression newCall = call instanceof PyDecorator ? elementGenerator.createDecoratorList("@" + builder.toString()).getDecorators()[0] : elementGenerator.createExpressionFromText(LanguageLevel.forElement(element), builder.toString());
                call.replace((PsiElement)newCall);
                return true;
            }
        } else if (element instanceof PyFunction) {
            PyChangeSignatureUsageProcessor.processFunctionDeclaration((PyChangeInfo)changeInfo, (PyFunction)element);
        }
        return false;
    }

    private StringBuilder buildSignature(PyChangeInfo changeInfo, PyCallExpression call) {
        PyArgumentList argumentList = call.getArgumentList();
        PyExpression callee = call.getCallee();
        String name = callee != null ? callee.getText() : changeInfo.getNewName();
        StringBuilder builder = new StringBuilder(name + "(");
        if (argumentList != null) {
            PyParameterInfo[] newParameters = changeInfo.getNewParameters();
            List<String> params = this.collectParameters(newParameters, argumentList);
            builder.append(StringUtil.join(params, (String)","));
        }
        builder.append(")");
        return builder;
    }

    private List<String> collectParameters(PyParameterInfo[] newParameters, @NotNull PyArgumentList argumentList) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor", "collectParameters"));
        }
        this.useKeywords = false;
        this.isMethod = false;
        this.isAfterStar = false;
        ArrayList<String> params = new ArrayList<String>();
        int currentIndex = 0;
        PyExpression[] arguments = argumentList.getArguments();
        for (PyParameterInfo info : newParameters) {
            int oldIndex = this.calculateOldIndex(info);
            String parameterName = info.getName();
            if (parameterName.equals("self") || parameterName.equals("*")) continue;
            if (parameterName.startsWith("**")) {
                currentIndex = PyChangeSignatureUsageProcessor.addKwArgs(params, arguments, currentIndex);
                continue;
            }
            if (parameterName.startsWith("*")) {
                currentIndex = PyChangeSignatureUsageProcessor.addPositionalContainer(params, arguments, currentIndex);
                continue;
            }
            if (oldIndex < 0) {
                this.addNewParameter(params, info);
                ++currentIndex;
                continue;
            }
            currentIndex = this.moveParameter(params, argumentList, info, currentIndex, oldIndex, arguments);
        }
        return params;
    }

    private int calculateOldIndex(ParameterInfo info) {
        if (info.getName().equals("self")) {
            this.isMethod = true;
        }
        if (info.getName().equals("*")) {
            this.isAfterStar = true;
            this.useKeywords = true;
        }
        int oldIndex = info.getOldIndex();
        oldIndex = this.isMethod ? oldIndex - 1 : oldIndex;
        oldIndex = this.isAfterStar ? oldIndex - 1 : oldIndex;
        return oldIndex;
    }

    private static int addPositionalContainer(List<String> params, PyExpression[] arguments, int index) {
        for (int i = index; i != arguments.length; ++i) {
            if (arguments[i] instanceof PyKeywordArgument) continue;
            params.add(arguments[i].getText());
            ++index;
        }
        return index;
    }

    private static int addKwArgs(List<String> params, PyExpression[] arguments, int index) {
        for (int i = index; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof PyKeywordArgument)) continue;
            params.add(arguments[i].getText());
            ++index;
        }
        return index;
    }

    private void addNewParameter(List<String> params, PyParameterInfo info) {
        if (info.getDefaultInSignature()) {
            this.useKeywords = true;
        } else {
            params.add(this.useKeywords ? info.getName() + " = " + info.getDefaultValue() : info.getDefaultValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int moveParameter(List<String> params, PyArgumentList argumentList, PyParameterInfo info, int currentIndex, int oldIndex, PyExpression[] arguments) {
        String paramName = info.getOldName();
        PyKeywordArgument keywordArgument = argumentList.getKeywordArgument(paramName);
        if (keywordArgument != null) {
            params.add(keywordArgument.getText());
            this.useKeywords = true;
            return currentIndex + 1;
        }
        if (currentIndex < arguments.length) {
            PyExpression currentParameter = arguments[currentIndex];
            if (currentParameter instanceof PyKeywordArgument && info.isRenamed()) {
                params.add(currentParameter.getText());
                return currentIndex + 1;
            }
            if (oldIndex >= arguments.length) return currentIndex;
            if (!info.getDefaultInSignature()) return this.addOldPositionParameter(params, arguments[oldIndex], info, currentIndex);
            if (!arguments[oldIndex].getText().equals(info.getDefaultValue())) return this.addOldPositionParameter(params, arguments[oldIndex], info, currentIndex);
            if (currentParameter instanceof PyKeywordArgument) return currentIndex;
            return this.addOldPositionParameter(params, arguments[oldIndex], info, currentIndex);
        }
        if (oldIndex < arguments.length) {
            return this.addOldPositionParameter(params, arguments[oldIndex], info, currentIndex);
        }
        if (info.getDefaultInSignature()) {
            this.useKeywords = true;
            return currentIndex;
        }
        params.add(this.useKeywords ? paramName + " = " + info.getDefaultValue() : info.getDefaultValue());
        return currentIndex + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int addOldPositionParameter(List<String> params, PyExpression argument, PyParameterInfo info, int currentIndex) {
        String paramName = info.getName();
        if (argument instanceof PyKeywordArgument) {
            PyExpression valueExpression = ((PyKeywordArgument)argument).getValueExpression();
            if (!paramName.equals(argument.getName()) && !StringUtil.isEmptyOrSpaces((String)info.getDefaultValue())) {
                if (info.getDefaultInSignature()) return currentIndex;
                params.add(this.useKeywords ? info.getName() + " = " + info.getDefaultValue() : info.getDefaultValue());
                return currentIndex + 1;
            } else {
                params.add(valueExpression == null ? paramName : paramName + " = " + valueExpression.getText());
                this.useKeywords = true;
            }
            return currentIndex + 1;
        } else {
            params.add(this.useKeywords && !argument.getText().equals(info.getDefaultValue()) ? paramName + " = " + argument.getText() : argument.getText());
        }
        return currentIndex + 1;
    }

    private static boolean isPythonUsage(UsageInfo info) {
        PsiElement element = info.getElement();
        if (element == null) {
            return false;
        }
        return element.getLanguage() == PythonLanguage.getInstance();
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (changeInfo instanceof PyChangeInfo && changeInfo.getLanguage().is((Language)PythonLanguage.getInstance())) {
            PyChangeInfo pyChangeInfo = (PyChangeInfo)changeInfo;
            PyChangeSignatureUsageProcessor.processFunctionDeclaration(pyChangeInfo, pyChangeInfo.getMethod());
            return true;
        }
        return false;
    }

    private static void processFunctionDeclaration(@NotNull PyChangeInfo changeInfo, @NotNull PyFunction function) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor", "processFunctionDeclaration"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor", "processFunctionDeclaration"));
        }
        if (changeInfo.isParameterNamesChanged()) {
            PyParameterInfo[] parameters = changeInfo.getNewParameters();
            for (int i = 0; i != parameters.length; ++i) {
                UsageInfo[] usages;
                PyParameterInfo paramInfo = parameters[i];
                PyParameter[] oldParameters = function.getParameterList().getParameters();
                if (paramInfo.getOldIndex() < 0 || !paramInfo.isRenamed()) continue;
                for (UsageInfo info : usages = RenameUtil.findUsages((PsiElement)oldParameters[paramInfo.getOldIndex()], paramInfo.getName(), true, false, null)) {
                    RenameUtil.rename(info, paramInfo.getName());
                }
            }
        }
        if (changeInfo.isParameterSetOrOrderChanged()) {
            PyChangeSignatureUsageProcessor.fixDoc(changeInfo, function);
            PyChangeSignatureUsageProcessor.updateParameterList(changeInfo, function);
        }
        if (changeInfo.isNameChanged()) {
            RenameUtil.doRenameGenericNamedElement(function, changeInfo.getNewName(), UsageInfo.EMPTY_ARRAY, null);
        }
    }

    private static void fixDoc(PyChangeInfo changeInfo, @NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor", "fixDoc"));
        }
        PyStringLiteralExpression docStringExpression = function.getDocStringExpression();
        if (docStringExpression == null) {
            return;
        }
        PyParameterInfo[] parameters = changeInfo.getNewParameters();
        HashSet names = new HashSet();
        for (PyParameterInfo info : parameters) {
            names.add(info.getName());
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)function);
        if (module == null) {
            return;
        }
        for (PyParameter p : function.getParameterList().getParameters()) {
            String paramName = p.getName();
            if (names.contains(paramName) || paramName == null) continue;
            PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
            String prefix = documentationSettings.isEpydocFormat(docStringExpression.getContainingFile()) ? "@" : ":";
            String replacement = PythonDocCommentUtil.removeParamFromDocstring(docStringExpression.getText(), prefix, paramName);
            PyExpression str = PyElementGenerator.getInstance(function.getProject()).createDocstring(replacement).getExpression();
            docStringExpression.replace((PsiElement)str);
        }
    }

    private static void updateParameterList(PyChangeInfo changeInfo, PyFunction baseMethod) {
        PyParameterList parameterList = baseMethod.getParameterList();
        PyParameterInfo[] parameters = changeInfo.getNewParameters();
        StringBuilder builder = new StringBuilder("def foo(");
        PyStringLiteralExpression docstring = baseMethod.getDocStringExpression();
        PyParameter[] oldParameters = baseMethod.getParameterList().getParameters();
        for (int i = 0; i != parameters.length; ++i) {
            String defaultValue;
            PyAnnotation annotation;
            PyParameter parameter;
            PyParameterInfo info = parameters[i];
            int oldIndex = info.getOldIndex();
            if (i != 0 && oldIndex < oldParameters.length) {
                builder.append(", ");
            }
            if (docstring != null && oldIndex < 0) {
                String replacement = new PyDocstringGenerator(baseMethod).withParam("param", info.getName()).docStringAsText();
                PyExpression str = PyElementGenerator.getInstance(baseMethod.getProject()).createDocstring(replacement).getExpression();
                docstring.replace((PsiElement)str);
            }
            if (oldIndex < oldParameters.length) {
                builder.append(info.getName());
            }
            if (oldIndex >= 0 && oldIndex < oldParameters.length && (parameter = oldParameters[oldIndex]) instanceof PyNamedParameter && (annotation = ((PyNamedParameter)parameter).getAnnotation()) != null) {
                builder.append(annotation.getText());
            }
            if ((defaultValue = info.getDefaultValue()) == null || !info.getDefaultInSignature() || StringUtil.isEmpty((String)defaultValue)) continue;
            builder.append(" = ").append(defaultValue);
        }
        builder.append("): pass");
        PyParameterList parameterList1 = PyElementGenerator.getInstance(baseMethod.getProject()).createFromText(LanguageLevel.forElement(baseMethod), PyFunction.class, builder.toString()).getParameterList();
        parameterList.replace((PsiElement)parameterList1);
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSnapshotProvider", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor", "registerConflictResolvers"));
        }
    }
}

