/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureHandler
implements ChangeSignatureHandler {
    @Nullable
    public PsiElement findTargetMember(PsiFile file, Editor editor) {
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        return this.findTargetMember(element);
    }

    @Nullable
    public PsiElement findTargetMember(@Nullable PsiElement element) {
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression != null) {
            return callExpression.resolveCalleeFunction(PyResolveContext.defaultContext());
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler", "invoke"));
        }
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PyChangeSignatureHandler.invokeOnElement(project, element, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PyChangeSignatureHandler.invokeOnElement(project, elements[0], editor);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]);
    }

    private static void invokeOnElement(Project project, PsiElement element, Editor editor) {
        PyParameter[] parameters;
        if (element instanceof PyLambdaExpression) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)"Caret is positioned on lambda call.");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)REFACTORING_NAME);
            return;
        }
        if (!(element instanceof PyFunction)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)REFACTORING_NAME);
            return;
        }
        if (PyChangeSignatureHandler.isNotUnderSourceRoot(project, element.getContainingFile(), editor)) {
            return;
        }
        PyFunction superMethod = PyChangeSignatureHandler.getSuperMethod((PyFunction)element);
        if (superMethod == null) {
            return;
        }
        if (!superMethod.equals(element)) {
            element = superMethod;
            if (PyChangeSignatureHandler.isNotUnderSourceRoot(project, superMethod.getContainingFile(), editor)) {
                return;
            }
        }
        PyFunction function = (PyFunction)element;
        for (PyParameter p : parameters = function.getParameterList().getParameters()) {
            if (!(p instanceof PyTupleParameter)) continue;
            String message = RefactoringBundle.getCannotRefactorMessage((String)"Function contains tuple parameters");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)REFACTORING_NAME);
            return;
        }
        PyMethodDescriptor method = new PyMethodDescriptor((PyFunction)element);
        PyChangeSignatureDialog dialog = new PyChangeSignatureDialog(project, method);
        dialog.show();
    }

    private static boolean isNotUnderSourceRoot(@NotNull Project project, @Nullable PsiFile psiFile, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler", "isNotUnderSourceRoot"));
        }
        if (psiFile == null) {
            return true;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(virtualFile)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)"Function is not under the source root");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)REFACTORING_NAME);
            return true;
        }
        return false;
    }

    @Nullable
    protected static PyFunction getSuperMethod(@Nullable PyFunction function) {
        if (function == null) {
            return null;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return function;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod(function);
        if (!deepestSuperMethod.equals(function)) {
            String baseClassName;
            PyClass baseClass = deepestSuperMethod.getContainingClass();
            PyBuiltinCache cache = PyBuiltinCache.getInstance(baseClass);
            String string = baseClassName = baseClass == null ? "" : baseClass.getName();
            if (cache.isBuiltin(baseClass)) {
                return function;
            }
            String message = PyBundle.message("refactoring.change.signature.find.usages.of.base.class", function.getName(), containingClass.getName(), baseClassName);
            int choice = ApplicationManagerEx.getApplicationEx().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)function.getProject(), (String)message, (String)REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
            switch (choice) {
                case 0: {
                    return deepestSuperMethod;
                }
                case 1: {
                    return function;
                }
            }
            return null;
        }
        return function;
    }
}

