/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReplaceExpressionUtil
implements PyElementTypes {
    public static final Key<Pair<PsiElement, TextRange>> SELECTION_BREAKS_AST_NODE = new Key("python.selection.breaks.ast.node");

    private PyReplaceExpressionUtil() {
    }

    public static boolean isNeedParenthesis(@NotNull PyElement oldExpr, @NotNull PyElement newExpr) {
        PyBinaryExpression binaryExpression;
        if (oldExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpr", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "isNeedParenthesis"));
        }
        if (newExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpr", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "isNeedParenthesis"));
        }
        PyElement parentExpr = (PyElement)oldExpr.getParent();
        if (parentExpr instanceof PyArgumentList) {
            return newExpr instanceof PyTupleExpression;
        }
        if (parentExpr instanceof PyParenthesizedExpression || !(parentExpr instanceof PyExpression)) {
            return false;
        }
        int newPriority = PyReplaceExpressionUtil.getExpressionPriority(newExpr);
        int parentPriority = PyReplaceExpressionUtil.getExpressionPriority(parentExpr);
        if (parentPriority > newPriority) {
            return true;
        }
        return parentPriority == newPriority && parentPriority != 0 && parentExpr instanceof PyBinaryExpression ? PyReplaceExpressionUtil.isNotAssociative(binaryExpression = (PyBinaryExpression)parentExpr) && oldExpr == PyReplaceExpressionUtil.getLeastPrioritySide(binaryExpression) : newExpr instanceof PyConditionalExpression && parentExpr instanceof PyConditionalExpression;
    }

    @Nullable
    private static PyExpression getLeastPrioritySide(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "getLeastPrioritySide"));
        }
        if (expression.isOperator("**")) {
            return expression.getLeftExpression();
        }
        return expression.getRightExpression();
    }

    public static PsiElement replaceExpression(@NotNull PsiElement oldExpression, @NotNull PsiElement newExpression) {
        if (oldExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceExpression"));
        }
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceExpression"));
        }
        Pair data = (Pair)oldExpression.getUserData(SELECTION_BREAKS_AST_NODE);
        if (data != null) {
            PsiElement element = (PsiElement)data.first;
            TextRange textRange = (TextRange)data.second;
            String parentText = element.getText();
            String prefix = parentText.substring(0, textRange.getStartOffset());
            String suffix = parentText.substring(textRange.getEndOffset(), element.getTextLength());
            PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
            LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
            if (element instanceof PyStringLiteralExpression) {
                return PyReplaceExpressionUtil.replaceSubstringInStringLiteral((PyStringLiteralExpression)element, newExpression, textRange);
            }
            PsiElement expression = (PsiElement)generator.createFromText(languageLevel, element.getClass(), prefix + newExpression.getText() + suffix);
            return element.replace(expression);
        }
        return oldExpression.replace(newExpression);
    }

    @Nullable
    private static PsiElement replaceSubstringInStringLiteral(@NotNull PyStringLiteralExpression oldExpression, @NotNull PsiElement newExpression, @NotNull TextRange textRange) {
        boolean hasSubstitutions;
        if (oldExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringInStringLiteral"));
        }
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringInStringLiteral"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringInStringLiteral"));
        }
        String fullText = oldExpression.getText();
        Pair detectedQuotes = PythonStringUtil.getQuotes(fullText);
        Pair quotes = detectedQuotes != null ? detectedQuotes : Pair.create((Object)"'", (Object)"'");
        String prefix = fullText.substring(0, textRange.getStartOffset());
        String suffix = fullText.substring(textRange.getEndOffset(), oldExpression.getTextLength());
        PyExpression formatValue = PyStringFormatParser.getFormatValueExpression(oldExpression);
        PyArgumentList newStyleFormatValue = PyStringFormatParser.getNewStyleFormatValueExpression(oldExpression);
        String newText = newExpression.getText();
        List<PyStringFormatParser.SubstitutionChunk> substitutions = newStyleFormatValue != null ? PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parseNewStyleFormat(fullText)) : PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(fullText));
        boolean bl = hasSubstitutions = substitutions.size() > 0;
        if (formatValue != null && !PyReplaceExpressionUtil.containsStringFormatting(substitutions, textRange)) {
            if (formatValue instanceof PyTupleExpression) {
                return PyReplaceExpressionUtil.replaceSubstringWithTupleFormatting(oldExpression, newExpression, textRange, prefix, suffix, (PyTupleExpression)formatValue, substitutions);
            }
            if (formatValue instanceof PyDictLiteralExpression) {
                return PyReplaceExpressionUtil.replaceSubstringWithDictFormatting(oldExpression, (Pair<String, String>)quotes, prefix, suffix, formatValue, newText);
            }
            TypeEvalContext context = TypeEvalContext.userInitiated(oldExpression.getProject(), oldExpression.getContainingFile());
            PyType valueType = context.getType(formatValue);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(oldExpression);
            PyClassType tupleType = builtinCache.getTupleType();
            PyType mappingType = PyTypeParser.getTypeByName(null, "collections.Mapping");
            if (!PyTypeChecker.match(tupleType, valueType, context) || mappingType != null && !PyTypeChecker.match(mappingType, valueType, context)) {
                return PyReplaceExpressionUtil.replaceSubstringWithSingleValueFormatting(oldExpression, textRange, prefix, suffix, formatValue, newText, substitutions);
            }
        }
        if (newStyleFormatValue != null && hasSubstitutions && !PyReplaceExpressionUtil.containsStringFormatting(substitutions, textRange)) {
            PyExpression[] arguments = newStyleFormatValue.getArguments();
            boolean hasStarArguments = false;
            for (PyExpression argument : arguments) {
                if (!(argument instanceof PyStarArgument)) continue;
                hasStarArguments = true;
            }
            if (!hasStarArguments) {
                return PyReplaceExpressionUtil.replaceSubstringWithNewStyleFormatting(oldExpression, textRange, prefix, suffix, newStyleFormatValue, newText, substitutions);
            }
        }
        if (PyReplaceExpressionUtil.isConcatFormatting(oldExpression) || hasSubstitutions) {
            return PyReplaceExpressionUtil.replaceSubstringWithConcatFormatting(oldExpression, (Pair<String, String>)quotes, prefix, suffix, newText, hasSubstitutions);
        }
        return PyReplaceExpressionUtil.replaceSubstringWithoutFormatting(oldExpression, prefix, suffix, newText);
    }

    private static PsiElement replaceSubstringWithSingleValueFormatting(PyStringLiteralExpression oldExpression, TextRange textRange, String prefix, String suffix, PyExpression formatValue, String newText, List<PyStringFormatParser.SubstitutionChunk> substitutions) {
        int pos;
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        String newLiteralText = prefix + "%s" + suffix;
        PyStringLiteralExpression newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        int i = PyReplaceExpressionUtil.getPositionInRanges(PyStringFormatParser.substitutionsToRanges(substitutions), textRange);
        if (i == 0) {
            pos = builder.toString().length();
            builder.append(newText);
            builder.append(",");
            builder.append(formatValue.getText());
        } else {
            builder.append(formatValue.getText());
            builder.append(",");
            pos = builder.toString().length();
            builder.append(newText);
        }
        builder.append(")");
        PsiElement newElement = formatValue.replace((PsiElement)generator.createExpressionFromText(languageLevel, builder.toString()));
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithDictFormatting(PyStringLiteralExpression oldExpression, Pair<String, String> quotes, String prefix, String suffix, PyExpression formatValue, String newText) {
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        String newLiteralText = prefix + "%(" + newText + ")s" + suffix;
        PyStringLiteralExpression newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        PyDictLiteralExpression dict = (PyDictLiteralExpression)formatValue;
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Object[] elements = dict.getElements();
        builder.append(StringUtil.join((Object[])elements, (Function)new Function<PyKeyValueExpression, String>(){

            public String fun(PyKeyValueExpression expression) {
                return expression.getText();
            }
        }, (String)","));
        if (elements.length > 0) {
            builder.append(",");
        }
        builder.append((String)quotes.getSecond());
        builder.append(newText);
        builder.append((String)quotes.getSecond());
        builder.append(":");
        int pos = builder.toString().length();
        builder.append(newText);
        builder.append("}");
        PyExpression newDictLiteral = generator.createExpressionFromText(languageLevel, builder.toString());
        PsiElement newElement = formatValue.replace((PsiElement)newDictLiteral);
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithTupleFormatting(PyStringLiteralExpression oldExpression, PsiElement newExpression, TextRange textRange, String prefix, String suffix, PyTupleExpression tupleFormatValue, List<PyStringFormatParser.SubstitutionChunk> substitutions) {
        String newLiteralText = prefix + "%s" + suffix;
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        PyStringLiteralExpression newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        PyExpression[] members = tupleFormatValue.getElements();
        int n = members.length;
        int i = Math.min(n, Math.max(0, PyReplaceExpressionUtil.getPositionInRanges(PyStringFormatParser.substitutionsToRanges(substitutions), textRange)));
        boolean last = i == n;
        ASTNode trailingComma = PyPsiUtils.getNextComma(members[n - 1].getNode());
        if (trailingComma != null) {
            tupleFormatValue.getNode().removeChild(trailingComma);
        }
        PyExpression before = last ? null : members[i];
        PyUtil.addListNode((PsiElement)tupleFormatValue, newExpression, before != null ? before.getNode() : null, i == 0 || !last, last, !last);
        return newExpression;
    }

    private static PsiElement replaceSubstringWithoutFormatting(@NotNull PyStringLiteralExpression oldExpression, @NotNull String prefix, @NotNull String suffix, @NotNull String newText) {
        if (oldExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithoutFormatting"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithoutFormatting"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithoutFormatting"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithoutFormatting"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        PsiElement parent = oldExpression.getParent();
        boolean parensNeeded = parent instanceof PyExpression && !(parent instanceof PyParenthesizedExpression);
        StringBuilder builder = new StringBuilder();
        if (parensNeeded) {
            builder.append("(");
        }
        builder.append(prefix);
        builder.append("%s");
        builder.append(suffix);
        builder.append(" % ");
        int pos = builder.toString().length();
        builder.append(newText);
        if (parensNeeded) {
            builder.append(")");
        }
        PyExpression expression = generator.createExpressionFromText(languageLevel, builder.toString());
        PsiElement newElement = oldExpression.replace((PsiElement)expression);
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithConcatFormatting(@NotNull PyStringLiteralExpression oldExpression, @NotNull Pair<String, String> quotes, @NotNull String prefix, @NotNull String suffix, @NotNull String newText, boolean hasSubstitutions) {
        if (oldExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithConcatFormatting"));
        }
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithConcatFormatting"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithConcatFormatting"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithConcatFormatting"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithConcatFormatting"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        String leftQuote = (String)quotes.getFirst();
        String rightQuote = (String)quotes.getSecond();
        StringBuilder builder = new StringBuilder();
        if (hasSubstitutions) {
            builder.append("(");
        }
        if (!leftQuote.endsWith(prefix)) {
            builder.append(prefix + rightQuote + " + ");
        }
        int pos = builder.toString().length();
        builder.append(newText);
        if (!rightQuote.startsWith(suffix)) {
            builder.append(" + " + leftQuote + suffix);
        }
        if (hasSubstitutions) {
            builder.append(")");
        }
        PyExpression expression = generator.createExpressionFromText(languageLevel, builder.toString());
        PsiElement newElement = oldExpression.replace((PsiElement)expression);
        return newElement.findElementAt(pos);
    }

    private static PsiElement replaceSubstringWithNewStyleFormatting(@NotNull PyStringLiteralExpression oldExpression, @NotNull TextRange textRange, @NotNull String prefix, @NotNull String suffix, @NotNull PyArgumentList newStyleFormatValue, @NotNull String newText, @NotNull List<PyStringFormatParser.SubstitutionChunk> substitutions) {
        PyStringLiteralExpression newLiteralExpression;
        String newLiteralText;
        if (oldExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        if (newStyleFormatValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStyleFormatValue", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "replaceSubstringWithNewStyleFormatting"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(oldExpression.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(oldExpression);
        PyExpression[] arguments = newStyleFormatValue.getArguments();
        boolean hasKeywords = false;
        int maxPosition = -1;
        for (PyStringFormatParser.SubstitutionChunk substitution : substitutions) {
            Integer position;
            if (substitution.getMappingKey() != null) {
                hasKeywords = true;
            }
            if ((position = substitution.getPosition()) == null || position <= maxPosition) continue;
            maxPosition = position;
        }
        if (hasKeywords) {
            newLiteralText = prefix + "{" + newText + "}" + suffix;
            newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
            oldExpression.replace(newLiteralExpression);
            PyKeywordArgument kwarg = generator.createKeywordArgument(languageLevel, newText, newText);
            newStyleFormatValue.addArgument(kwarg);
            return kwarg.getValueExpression();
        }
        if (maxPosition >= 0) {
            newLiteralText = prefix + "{" + (maxPosition + 1) + "}" + suffix;
            newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
            oldExpression.replace(newLiteralExpression);
            PyExpression arg = generator.createExpressionFromText(languageLevel, newText);
            newStyleFormatValue.addArgument(arg);
            return arg;
        }
        newLiteralText = prefix + "{}" + suffix;
        newLiteralExpression = generator.createStringLiteralAlreadyEscaped(newLiteralText);
        oldExpression.replace(newLiteralExpression);
        int i = PyReplaceExpressionUtil.getPositionInRanges(PyStringFormatParser.substitutionsToRanges(substitutions), textRange);
        PyExpression arg = generator.createExpressionFromText(languageLevel, newText);
        if (i == 0) {
            newStyleFormatValue.addArgumentFirst(arg);
        } else if (i < arguments.length) {
            newStyleFormatValue.addArgumentAfter(arg, arguments[i - 1]);
        } else {
            newStyleFormatValue.addArgument(arg);
        }
        return arg;
    }

    private static int getPositionInRanges(@NotNull List<TextRange> ranges, @NotNull TextRange range) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "getPositionInRanges"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "getPositionInRanges"));
        }
        int end = range.getEndOffset();
        int size = ranges.size();
        for (int i = 0; i < size; ++i) {
            TextRange r = ranges.get(i);
            if (end >= r.getStartOffset()) continue;
            return i;
        }
        return size;
    }

    private static boolean containsStringFormatting(@NotNull List<PyStringFormatParser.SubstitutionChunk> substitutions, @NotNull TextRange range) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "containsStringFormatting"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "containsStringFormatting"));
        }
        List<TextRange> ranges = PyStringFormatParser.substitutionsToRanges(substitutions);
        for (TextRange r : ranges) {
            if (!range.contains(r)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConcatFormatting(PyStringLiteralExpression element) {
        PsiElement parent = element.getParent();
        return parent instanceof PyBinaryExpression && ((PyBinaryExpression)parent).isOperator("+");
    }

    private static boolean isNotAssociative(@NotNull PyBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "isNotAssociative"));
        }
        IElementType opType = PyReplaceExpressionUtil.getOperationType(binaryExpression);
        return PyTokenTypes.COMPARISON_OPERATIONS.contains(opType) || binaryExpression instanceof PySliceExpression || opType == PyTokenTypes.DIV || opType == PyTokenTypes.FLOORDIV || opType == PyTokenTypes.PERC || opType == PyTokenTypes.EXP || opType == PyTokenTypes.MINUS;
    }

    private static int getExpressionPriority(PyElement expr) {
        int priority = 0;
        if (expr instanceof PyReferenceExpression || expr instanceof PySubscriptionExpression || expr instanceof PySliceExpression || expr instanceof PyCallExpression) {
            priority = 1;
        } else if (expr instanceof PyPrefixExpression) {
            IElementType opType = PyReplaceExpressionUtil.getOperationType(expr);
            if (opType == PyTokenTypes.PLUS || opType == PyTokenTypes.MINUS || opType == PyTokenTypes.TILDE) {
                priority = 2;
            }
            if (opType == PyTokenTypes.NOT_KEYWORD) {
                priority = 11;
            }
        } else if (expr instanceof PyBinaryExpression) {
            IElementType opType = PyReplaceExpressionUtil.getOperationType(expr);
            if (opType == PyTokenTypes.EXP) {
                priority = 3;
            }
            if (opType == PyTokenTypes.MULT || opType == PyTokenTypes.DIV || opType == PyTokenTypes.PERC || opType == PyTokenTypes.FLOORDIV) {
                priority = 4;
            }
            if (opType == PyTokenTypes.PLUS || opType == PyTokenTypes.MINUS) {
                priority = 5;
            }
            if (opType == PyTokenTypes.LTLT || opType == PyTokenTypes.GTGT) {
                priority = 6;
            }
            if (opType == PyTokenTypes.AND) {
                priority = 7;
            }
            if (opType == PyTokenTypes.XOR) {
                priority = 8;
            }
            if (opType == PyTokenTypes.OR) {
                priority = 9;
            }
            if (PyTokenTypes.COMPARISON_OPERATIONS.contains(opType)) {
                priority = 10;
            }
            if (opType == PyTokenTypes.AND_KEYWORD) {
                priority = 12;
            }
            if (opType == PyTokenTypes.OR_KEYWORD) {
                priority = 13;
            }
        } else if (expr instanceof PyConditionalExpression) {
            priority = 14;
        } else if (expr instanceof PyLambdaExpression) {
            priority = 15;
        }
        return -priority;
    }

    @Nullable
    private static IElementType getOperationType(@NotNull PyElement expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/refactoring/PyReplaceExpressionUtil", "getOperationType"));
        }
        if (expr instanceof PyBinaryExpression) {
            return ((PyBinaryExpression)expr).getOperator();
        }
        return ((PyPrefixExpression)expr).getOperator();
    }
}

