/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.findUsages.PyFindUsagesHandlerFactory;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRefactoringUtil {
    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable PsiElement context) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getOccurrences"));
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getOccurrences"));
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        PyElementVisitor visitor = new PyElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                Pair selection;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/PyRefactoringUtil$1", "visitElement"));
                }
                if (element instanceof PyParameter) {
                    return;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)pattern)) {
                    occurrences.add(element);
                    return;
                }
                if (element instanceof PyStringLiteralExpression && (selection = (Pair)pattern.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
                    int start;
                    String substring = ((TextRange)selection.getSecond()).substring(pattern.getText());
                    PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
                    String text = element.getText();
                    if (text != null && expr.getStringNodes().size() == 1 && (start = text.indexOf(substring)) >= 0) {
                        element.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)element, (Object)TextRange.from((int)start, (int)substring.length())));
                        occurrences.add(element);
                        return;
                    }
                }
                element.acceptChildren((PsiElementVisitor)this);
            }
        };
        context.acceptChildren((PsiElementVisitor)visitor);
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getOccurrences"));
        }
        return arrayList;
    }

    @Nullable
    public static PyExpression getSelectedExpression(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getSelectedExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getSelectedExpression"));
        }
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getSelectedExpression"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/jetbrains/python/refactoring/PyRefactoringUtil", "getSelectedExpression"));
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent != null && !(parent instanceof PyElement)) {
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PyElement.class);
        }
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof PyExpression)) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyImportStatement.class, PyFromImportStatement.class}) != null) {
            return null;
        }
        if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)parent) && element2 == PsiTreeUtil.getDeepestLast((PsiElement)parent)) {
            return (PyExpression)parent;
        }
        if (parent instanceof PyBinaryExpression) {
            LanguageLevel langLevel;
            String selection = file.getText().substring(element1.getTextOffset(), element2.getTextOffset() + element2.getTextLength());
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            PyExpression expression = generator.createFromText(langLevel = LanguageLevel.forElement(element1), PyAssignmentStatement.class, "z=" + selection).getAssignedValue();
            if (!(expression instanceof PyBinaryExpression) || PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return null;
            }
            String parentText = parent.getText();
            int startOffset = element1.getTextOffset() - parent.getTextOffset() - 1;
            if (startOffset < 0) {
                return null;
            }
            int endOffset = element2.getTextOffset() + element2.getTextLength() - parent.getTextOffset();
            String prefix = parentText.substring(0, startOffset);
            String suffix = parentText.substring(endOffset, parentText.length());
            TextRange textRange = TextRange.from((int)startOffset, (int)(endOffset - startOffset));
            PsiElement fakeExpression = (PsiElement)generator.createFromText(langLevel, parent.getClass(), prefix + "python" + suffix);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)fakeExpression)) {
                return null;
            }
            expression.putUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE, Pair.create((Object)parent, (Object)textRange));
            return expression;
        }
        return null;
    }

    @NotNull
    public static Collection<String> collectUsedNames(@Nullable PsiElement scope) {
        if (!(scope instanceof PyClass || scope instanceof PyFile || scope instanceof PyFunction)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "collectUsedNames"));
            }
            return list;
        }
        HashSet<String> variables = new HashSet<String>(){

            public boolean add(String s) {
                return s != null && super.add((Object)s);
            }
        };
        scope.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor((Set)variables){
            final /* synthetic */ Set val$variables;
            {
                this.val$variables = set;
            }

            @Override
            public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/PyRefactoringUtil$3", "visitPyTargetExpression"));
                }
                this.val$variables.add(node.getName());
            }

            @Override
            public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/PyRefactoringUtil$3", "visitPyNamedParameter"));
                }
                this.val$variables.add(node.getName());
            }

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                if (!node.isQualified()) {
                    this.val$variables.add(node.getReferencedName());
                } else {
                    super.visitPyReferenceExpression(node);
                }
            }

            @Override
            public void visitPyFunction(@NotNull PyFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/PyRefactoringUtil$3", "visitPyFunction"));
                }
                this.val$variables.add(node.getName());
            }

            @Override
            public void visitPyClass(@NotNull PyClass node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/PyRefactoringUtil$3", "visitPyClass"));
                }
                this.val$variables.add(node.getName());
            }
        });
        HashSet<String> hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "collectUsedNames"));
        }
        return hashSet;
    }

    @Nullable
    public static PsiElement findExpressionInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findExpressionInRange"));
        }
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        return PyRefactoringUtil.getSelectedExpression(file.getProject(), file, element1, element2);
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
        }
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (parent instanceof PyStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PyStatementList) break;
            if (parent == null || parent instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element1 instanceof PyFunction || element1 instanceof PyClass) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (element2 instanceof PyFunction || element2 instanceof PyClass) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] children = parent.getChildren();
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals(element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof PyStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findStatementsInRange"));
        }
        return psiElementArray;
    }

    private PyRefactoringUtil() {
    }

    public static boolean areConflictingMethods(PyFunction pyFunction, PyFunction pyFunction1) {
        String secondName;
        PyParameter[] firstParams = pyFunction.getParameterList().getParameters();
        PyParameter[] secondParams = pyFunction1.getParameterList().getParameters();
        String firstName = pyFunction.getName();
        return Comparing.strEqual((String)firstName, (String)(secondName = pyFunction1.getName())) && firstParams.length == secondParams.length;
    }

    @NotNull
    public static List<UsageInfo> findUsages(@NotNull PsiNamedElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findUsages"));
        }
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        FindUsagesHandler handler = new PyFindUsagesHandlerFactory().createFindUsagesHandler((PsiElement)element, forHighlightUsages);
        assert (handler != null);
        ArrayList<PsiElement> elementsToProcess = new ArrayList<PsiElement>();
        elementsToProcess.addAll(Arrays.asList(handler.getPrimaryElements()));
        elementsToProcess.addAll(Arrays.asList(handler.getSecondaryElements()));
        for (PsiElement e : elementsToProcess) {
            handler.processElementUsages(e, new Processor<UsageInfo>(){

                public boolean process(UsageInfo usageInfo) {
                    if (!usageInfo.isNonCodeUsage) {
                        usages.add(usageInfo);
                    }
                    return true;
                }
            }, FindUsagesHandler.createFindUsagesOptions(element.getProject(), null));
        }
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyRefactoringUtil", "findUsages"));
        }
        return arrayList;
    }
}

