/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result) {
        if (!(element instanceof PyElement)) {
            return null;
        }
        String name = ((PyElement)element).getName();
        if (name == null) {
            return null;
        }
        if (element instanceof PyClass) {
            result.add(this.toCamelCase(name, true));
        } else if (element instanceof PyFunction || element instanceof PyParameter) {
            result.add(name.toLowerCase());
        } else {
            result.add(name.toLowerCase());
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
            if (assignmentStatement != null) {
                return null;
            }
            result.add(name.toUpperCase());
            result.add(this.toCamelCase(name, false));
        }
        return SuggestedNameInfo.NULL_INFO;
    }

    @NotNull
    protected String toCamelCase(@NotNull String name, boolean uppercaseFirstLetter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/PyNameSuggestionProvider", "toCamelCase"));
        }
        List strings = StringUtil.split((String)name, (String)"_");
        if (strings.size() > 0) {
            StringBuilder buf = new StringBuilder();
            String str = ((String)strings.get(0)).toLowerCase();
            if (uppercaseFirstLetter) {
                str = StringUtil.capitalize((String)str);
            }
            buf.append(str);
            for (int i = 1; i < strings.size(); ++i) {
                buf.append(StringUtil.capitalize((String)((String)strings.get(i)).toLowerCase()));
            }
            String string = buf.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyNameSuggestionProvider", "toCamelCase"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyNameSuggestionProvider", "toCamelCase"));
        }
        return string;
    }
}

