/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDefUseUtil {
    private PyDefUseUtil() {
    }

    @NotNull
    public static List<ReadWriteInstruction> getLatestDefs(ScopeOwner block, String varName, PsiElement anchor, boolean acceptTypeAssertions) {
        Collection pred;
        int instr;
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(block);
        Instruction[] instructions = controlFlow.getInstructions();
        PyAugAssignmentStatement augAssignment = PyAugAssignmentStatementNavigator.getStatementByTarget(anchor);
        if (augAssignment != null) {
            anchor = augAssignment;
        }
        if ((instr = ControlFlowUtil.findInstructionNumberByElement(instructions, anchor)) < 0) {
            List<ReadWriteInstruction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyDefUseUtil", "getLatestDefs"));
            }
            return list;
        }
        if (anchor instanceof PyTargetExpression && !(pred = instructions[instr].allPred()).isEmpty()) {
            instr = ((Instruction)pred.iterator().next()).num();
        }
        Collection<ReadWriteInstruction> result = PyDefUseUtil.getLatestDefs(varName, instructions, instr, acceptTypeAssertions);
        ArrayList<ReadWriteInstruction> arrayList = new ArrayList<ReadWriteInstruction>(result);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyDefUseUtil", "getLatestDefs"));
        }
        return arrayList;
    }

    private static Collection<ReadWriteInstruction> getLatestDefs(final String varName, Instruction[] instructions, int instr, final boolean acceptTypeAssertions) {
        final LinkedHashSet<ReadWriteInstruction> result = new LinkedHashSet<ReadWriteInstruction>();
        ControlFlowUtil.iteratePrev(instr, instructions, new Function<Instruction, ControlFlowUtil.Operation>(){

            public ControlFlowUtil.Operation fun(Instruction instruction) {
                if (instruction instanceof ReadWriteInstruction) {
                    ReadWriteInstruction rwInstruction = (ReadWriteInstruction)instruction;
                    PsiElement element = instruction.getElement();
                    String name = PyDefUseUtil.elementName(element);
                    ReadWriteInstruction.ACCESS access = rwInstruction.getAccess();
                    if ((access.isWriteAccess() || acceptTypeAssertions && access.isAssertTypeAccess()) && Comparing.strEqual((String)name, (String)varName)) {
                        result.add(rwInstruction);
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
                return ControlFlowUtil.Operation.NEXT;
            }
        });
        return result;
    }

    @Nullable
    private static String elementName(PsiElement element) {
        QualifiedName qname;
        if (element instanceof PyImportElement) {
            return ((PyImportElement)element).getVisibleName();
        }
        if (element instanceof PyReferenceExpression && (qname = ((PyReferenceExpression)element).asQualifiedName()) != null) {
            return qname.toString();
        }
        return element instanceof PyElement ? ((PyElement)element).getName() : null;
    }

    @NotNull
    public static PsiElement[] getPostRefs(ScopeOwner block, PyTargetExpression var, PyExpression anchor) {
        ControlFlow controlFlow = ControlFlowCache.getControlFlow(block);
        Instruction[] instructions = controlFlow.getInstructions();
        int instr = ControlFlowUtil.findInstructionNumberByElement(instructions, (PsiElement)anchor);
        if (instr < 0) {
            PyElement[] pyElementArray = new PyElement[]{};
            if (pyElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyDefUseUtil", "getPostRefs"));
            }
            return pyElementArray;
        }
        boolean[] visited = new boolean[instructions.length];
        HashSet result = Sets.newHashSet();
        for (Instruction instruction : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction.num(), visited, result);
        }
        PsiElement[] psiElementArray = (PsiElement[])result.toArray(new PyElement[result.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/PyDefUseUtil", "getPostRefs"));
        }
        return psiElementArray;
    }

    private static void getPostRefs(PyTargetExpression var, Instruction[] instructions, int instr, boolean[] visited, Collection<PyElement> result) {
        ReadWriteInstruction instruction;
        PsiElement element;
        String name;
        if (visited[instr]) {
            return;
        }
        visited[instr] = true;
        if (instructions[instr] instanceof ReadWriteInstruction && Comparing.strEqual((String)(name = PyDefUseUtil.elementName(element = (instruction = (ReadWriteInstruction)instructions[instr]).getElement())), (String)var.getName())) {
            ReadWriteInstruction.ACCESS access = instruction.getAccess();
            if (access.isWriteAccess()) {
                return;
            }
            result.add((PyElement)instruction.getElement());
        }
        for (Instruction instruction2 : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction2.num(), visited, result);
        }
    }

    public static class InstructionNotFoundException
    extends RuntimeException {
    }
}

