/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class NameSuggesterUtil {
    private NameSuggesterUtil() {
    }

    private static String deleteNonLetterFromString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/jetbrains/python/refactoring/NameSuggesterUtil", "deleteNonLetterFromString"));
        }
        Pattern pattern = Pattern.compile("[^a-zA-Z_]+");
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll("_");
    }

    @NotNull
    public static Collection<String> generateNames(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/NameSuggesterUtil", "generateNames"));
        }
        if ((name = StringUtil.decapitalize((String)NameSuggesterUtil.deleteNonLetterFromString(StringUtil.unquoteString((String)name.replace('.', '_'))))).startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        }
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        int length = name.length();
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        for (int i = 0; i < length; ++i) {
            String candidate;
            if (!Character.isLetter(name.charAt(i)) || i != 0 && name.charAt(i - 1) != '_' && (!Character.isLowerCase(name.charAt(i - 1)) || !Character.isUpperCase(name.charAt(i))) || (candidate = StringUtil.decapitalize((String)NameSuggesterUtil.toUnderscoreCase(name.substring(i)))).length() >= 25) continue;
            possibleNames.add(candidate);
        }
        ArrayList<String> reversed = new ArrayList<String>(possibleNames);
        Collections.reverse(reversed);
        ArrayList<String> arrayList = reversed;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/NameSuggesterUtil", "generateNames"));
        }
        return arrayList;
    }

    public static Collection<String> generateNamesByType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/NameSuggesterUtil", "generateNamesByType"));
        }
        LinkedHashSet<String> possibleNames = new LinkedHashSet<String>();
        name = StringUtil.decapitalize((String)NameSuggesterUtil.deleteNonLetterFromString(name.replace('.', '_')));
        name = NameSuggesterUtil.toUnderscoreCase(name);
        possibleNames.add(name);
        possibleNames.add(name.substring(0, 1));
        return possibleNames;
    }

    @NotNull
    public static String toUnderscoreCase(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/NameSuggesterUtil", "toUnderscoreCase"));
        }
        StringBuilder buffer = new StringBuilder();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char chNext;
            char ch = name.charAt(i);
            if (ch != '-') {
                buffer.append(Character.toLowerCase(ch));
            } else {
                buffer.append("_");
            }
            if (!Character.isLetterOrDigit(ch)) continue;
            if (Character.isUpperCase(ch)) {
                if (i + 2 >= length) continue;
                chNext = name.charAt(i + 1);
                char chNextNext = name.charAt(i + 2);
                if (!Character.isUpperCase(chNext) || !Character.isLowerCase(chNextNext)) continue;
                buffer.append('_');
                continue;
            }
            if (!Character.isLowerCase(ch) && !Character.isDigit(ch) || i + 1 >= length || !Character.isUpperCase(chNext = name.charAt(i + 1))) continue;
            buffer.append('_');
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/NameSuggesterUtil", "toUnderscoreCase"));
        }
        return string;
    }
}

