/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.quickFixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveTrailingBlankLinesFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @NotNull
    public String getText() {
        if ("Remove trailing blank lines" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "getText"));
        }
        return "Remove trailing blank lines";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "invoke"));
        }
        RemoveTrailingBlankLinesFix.removeTrailingBlankLines(file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/quickFixes/RemoveTrailingBlankLinesFix", "applyFix"));
        }
        RemoveTrailingBlankLinesFix.removeTrailingBlankLines(descriptor.getPsiElement().getContainingFile());
    }

    private static void removeTrailingBlankLines(PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        int lastBlankLineOffset = -1;
        for (int i = document.getLineCount() - 1; i >= 0; --i) {
            int lineStart = document.getLineStartOffset(i);
            String trimmed = ((Object)document.getCharsSequence().subSequence(lineStart, document.getLineEndOffset(i))).toString().trim();
            if (trimmed.length() > 0) break;
            lastBlankLineOffset = lineStart;
        }
        if (lastBlankLineOffset > 0) {
            document.deleteString(lastBlankLineOffset, document.getTextLength());
        }
    }
}

