/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PsiModificationTracker;
import com.jetbrains.python.psi.types.TypeEvalConstraints;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class TypeEvalContextCache {
    @NotNull
    private final Map<TypeEvalConstraints, TypeEvalContext> myCache = new HashMap<TypeEvalConstraints, TypeEvalContext>();
    private long myModificationCount = -1L;
    @NotNull
    private final Object myLock = new Object();

    TypeEvalContextCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    TypeEvalContext getContext(@NotNull Project project, @NotNull TypeEvalContext standard) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/types/TypeEvalContextCache", "getContext"));
        }
        if (standard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standard", "com/jetbrains/python/psi/types/TypeEvalContextCache", "getContext"));
        }
        PsiModificationTracker tracker = PsiModificationTracker.SERVICE.getInstance((Project)project);
        Object object = this.myLock;
        // MONITORENTER : object
        long currentCount = tracker.getModificationCount();
        if (currentCount == this.myModificationCount) {
            TypeEvalContext valueFromCache = this.myCache.get(standard.getConstraints());
            if (valueFromCache != null) {
                TypeEvalContext typeEvalContext = valueFromCache;
                // MONITOREXIT : object
                if (typeEvalContext != null) return typeEvalContext;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/TypeEvalContextCache", "getContext"));
            }
        } else {
            this.myCache.clear();
            this.myModificationCount = currentCount;
        }
        this.myCache.put(standard.getConstraints(), standard);
        TypeEvalContext typeEvalContext = standard;
        // MONITOREXIT : object
        if (typeEvalContext != null) return typeEvalContext;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/TypeEvalContextCache", "getContext"));
    }
}

