/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalConstraints;
import com.jetbrains.python.psi.types.TypeEvalContextCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeEvalContext {
    @NotNull
    private static final TypeEvalContextCache CACHE = new TypeEvalContextCache();
    @NotNull
    private final TypeEvalConstraints myConstraints;
    private List<String> myTrace;
    private String myTraceIndent = "";
    private final Map<PyTypedElement, PyType> myEvaluated = new HashMap<PyTypedElement, PyType>();
    private final Map<Callable, PyType> myEvaluatedReturn = new HashMap<Callable, PyType>();
    private final ThreadLocal<Set<PyTypedElement>> myEvaluating = new ThreadLocal<Set<PyTypedElement>>(){

        @Override
        protected Set<PyTypedElement> initialValue() {
            return new HashSet<PyTypedElement>();
        }
    };
    private final ThreadLocal<Set<Callable>> myEvaluatingReturn = new ThreadLocal<Set<Callable>>(){

        @Override
        protected Set<Callable> initialValue() {
            return new HashSet<Callable>();
        }
    };

    private TypeEvalContext(boolean allowDataFlow, boolean allowStubToAST, @Nullable PsiFile origin) {
        this.myConstraints = new TypeEvalConstraints(allowDataFlow, allowStubToAST, origin);
    }

    public String toString() {
        return String.format("TypeEvalContext(%b, %b, %s)", this.myConstraints.myAllowDataFlow, this.myConstraints.myAllowStubToAST, this.myConstraints.myOrigin);
    }

    public boolean allowDataFlow(PsiElement element) {
        return this.myConstraints.myAllowDataFlow || element.getContainingFile() == this.myConstraints.myOrigin;
    }

    public boolean allowReturnTypes(PsiElement element) {
        return this.myConstraints.myAllowDataFlow || element.getContainingFile() == this.myConstraints.myOrigin;
    }

    public boolean allowLocalUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/types/TypeEvalContext", "allowLocalUsages"));
        }
        return this.myConstraints.myAllowStubToAST && this.myConstraints.myAllowDataFlow && element.getContainingFile() == this.myConstraints.myOrigin;
    }

    public static TypeEvalContext userInitiated(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/types/TypeEvalContext", "userInitiated"));
        }
        return CACHE.getContext(project, new TypeEvalContext(true, true, origin));
    }

    public static TypeEvalContext codeAnalysis(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/types/TypeEvalContext", "codeAnalysis"));
        }
        return CACHE.getContext(project, new TypeEvalContext(false, false, origin));
    }

    public static TypeEvalContext codeInsightFallback(@Nullable Project project) {
        TypeEvalContext anchor = new TypeEvalContext(false, false, null);
        if (project != null) {
            return CACHE.getContext(project, anchor);
        }
        return anchor;
    }

    public static TypeEvalContext deepCodeInsight(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/types/TypeEvalContext", "deepCodeInsight"));
        }
        return CACHE.getContext(project, new TypeEvalContext(false, true, null));
    }

    public TypeEvalContext withTracing() {
        if (this.myTrace == null) {
            this.myTrace = new ArrayList<String>();
        }
        return this;
    }

    public void trace(String message, Object ... args) {
        if (this.myTrace != null) {
            this.myTrace.add(this.myTraceIndent + String.format(message, args));
        }
    }

    public void traceIndent() {
        if (this.myTrace != null) {
            this.myTraceIndent = this.myTraceIndent + "  ";
        }
    }

    public void traceUnindent() {
        if (this.myTrace != null && this.myTraceIndent.length() >= 2) {
            this.myTraceIndent = this.myTraceIndent.substring(0, this.myTraceIndent.length() - 2);
        }
    }

    public String printTrace() {
        return StringUtil.join(this.myTrace, (String)"\n");
    }

    public boolean tracing() {
        return this.myTrace != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PyType getType(@NotNull PyTypedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/types/TypeEvalContext", "getType"));
        }
        Set<PyTypedElement> evaluating = this.myEvaluating.get();
        if (evaluating.contains(element)) {
            return null;
        }
        evaluating.add(element);
        try {
            Map<PyTypedElement, PyType> map = this.myEvaluated;
            synchronized (map) {
                if (this.myEvaluated.containsKey(element)) {
                    PyType type = this.myEvaluated.get(element);
                    TypeEvalContext.assertValid(type, element);
                    PyType pyType = type;
                    return pyType;
                }
            }
            PyType type = element.getType(this, Key.INSTANCE);
            TypeEvalContext.assertValid(type, element);
            Object object = this.myEvaluated;
            synchronized (object) {
                this.myEvaluated.put(element, type);
            }
            object = type;
            return object;
        }
        finally {
            evaluating.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PyType getReturnType(@NotNull Callable callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/types/TypeEvalContext", "getReturnType"));
        }
        Set<Callable> evaluating = this.myEvaluatingReturn.get();
        if (evaluating.contains(callable)) {
            return null;
        }
        evaluating.add(callable);
        try {
            Map<Callable, PyType> map = this.myEvaluatedReturn;
            synchronized (map) {
                if (this.myEvaluatedReturn.containsKey(callable)) {
                    PyType type = this.myEvaluatedReturn.get(callable);
                    TypeEvalContext.assertValid(type, callable);
                    PyType pyType = type;
                    return pyType;
                }
            }
            PyType type = callable.getReturnType(this, Key.INSTANCE);
            TypeEvalContext.assertValid(type, callable);
            Object object = this.myEvaluatedReturn;
            synchronized (object) {
                this.myEvaluatedReturn.put(callable, type);
            }
            object = type;
            return object;
        }
        finally {
            evaluating.remove(callable);
        }
    }

    private static void assertValid(@Nullable PyType result, @NotNull PyTypedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/types/TypeEvalContext", "assertValid"));
        }
        if (result != null) {
            result.assertValid(element.toString());
        }
    }

    public boolean maySwitchToAST(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/types/TypeEvalContext", "maySwitchToAST"));
        }
        return this.myConstraints.myAllowStubToAST || this.myConstraints.myOrigin == element.getContainingFile();
    }

    @Nullable
    public PsiFile getOrigin() {
        return this.myConstraints.myOrigin;
    }

    @NotNull
    TypeEvalConstraints getConstraints() {
        TypeEvalConstraints typeEvalConstraints = this.myConstraints;
        if (typeEvalConstraints == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/TypeEvalContext", "getConstraints"));
        }
        return typeEvalConstraints;
    }

    public static class Key {
        private static final Key INSTANCE = new Key();

        private Key() {
        }
    }
}

