/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeProviderBase
implements PyTypeProvider {
    private final ReturnTypeCallback mySelfTypeCallback = new ReturnTypeCallback(){

        @Override
        public PyType getType(@Nullable PyCallSiteExpression callSite, @Nullable PyType qualifierType, TypeEvalContext context) {
            if (qualifierType instanceof PyClassType) {
                PyClass aClass = ((PyClassType)qualifierType).getPyClass();
                return PyPsiFacade.getInstance(aClass.getProject()).createClassType(aClass, false);
            }
            return null;
        }
    };
    private final Map<String, ReturnTypeDescriptor> myMethodToReturnTypeMap = new FactoryMap<String, ReturnTypeDescriptor>(){

        protected ReturnTypeDescriptor create(String key) {
            return new ReturnTypeDescriptor();
        }
    };

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getReferenceExpressionType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getReferenceExpressionType"));
        }
        return null;
    }

    @Override
    public PyType getReferenceType(@NotNull PsiElement referenceTarget, TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceTarget", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getReferenceType"));
        }
        return null;
    }

    @Override
    public PyType getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getParameterType"));
        }
        if (func == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getParameterType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getParameterType"));
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull Callable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getReturnType"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PyType getCallType(@NotNull PyFunction function, @Nullable PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        ReturnTypeDescriptor descriptor;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getCallType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getCallType"));
        }
        Map<String, ReturnTypeDescriptor> map = this.myMethodToReturnTypeMap;
        synchronized (map) {
            descriptor = this.myMethodToReturnTypeMap.get(function.getName());
        }
        if (descriptor != null) {
            return descriptor.get(function, callSite, context);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getContextManagerVariableType(PyClass contextManager, PyExpression withExpression, TypeEvalContext context) {
        return null;
    }

    @Override
    @Nullable
    public PyType getCallableType(@NotNull Callable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getCallableType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeProviderBase", "getCallableType"));
        }
        return null;
    }

    protected void registerSelfReturnType(String classQualifiedName, Collection<String> methods) {
        this.registerReturnType(classQualifiedName, methods, this.mySelfTypeCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerReturnType(String classQualifiedName, Collection<String> methods, ReturnTypeCallback callback) {
        Map<String, ReturnTypeDescriptor> map = this.myMethodToReturnTypeMap;
        synchronized (map) {
            for (String method : methods) {
                this.myMethodToReturnTypeMap.get(method).put(classQualifiedName, callback);
            }
        }
    }

    private static class ReturnTypeDescriptor {
        private final Map<String, ReturnTypeCallback> myStringToReturnTypeMap = new HashMap<String, ReturnTypeCallback>();

        private ReturnTypeDescriptor() {
        }

        void put(String className, ReturnTypeCallback callback) {
            this.myStringToReturnTypeMap.put(className, callback);
        }

        @Nullable
        public PyType get(PyFunction function, @Nullable PyCallSiteExpression callSite, TypeEvalContext context) {
            ReturnTypeCallback typeCallback;
            PyClass containingClass = function.getContainingClass();
            if (containingClass != null && (typeCallback = this.myStringToReturnTypeMap.get(containingClass.getQualifiedName())) != null) {
                PyExpression callee = callSite instanceof PyCallExpression ? ((PyCallExpression)callSite).getCallee() : null;
                PyExpression qualifier = callee instanceof PyQualifiedExpression ? ((PyQualifiedExpression)callee).getQualifier() : null;
                PyType qualifierType = qualifier != null ? context.getType(qualifier) : null;
                return typeCallback.getType(callSite, qualifierType, context);
            }
            return null;
        }
    }

    protected static interface ReturnTypeCallback {
        @Nullable
        public PyType getType(@Nullable PyCallSiteExpression var1, @Nullable PyType var2, TypeEvalContext var3);
    }
}

