/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameResolverImpl;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeLexer;
import com.jetbrains.python.psi.types.PyTypeTokenTypes;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.psi.types.functionalParser.ForwardDeclaration;
import com.jetbrains.python.psi.types.functionalParser.FunctionalParser;
import com.jetbrains.python.psi.types.functionalParser.FunctionalParserBase;
import com.jetbrains.python.psi.types.functionalParser.ParserException;
import com.jetbrains.python.psi.types.functionalParser.Token;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeParser {
    private static final ParseResult EMPTY_RESULT = new ParseResult(null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());

    @Nullable
    public static PyType getTypeByName(@Nullable PsiElement anchor, @NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/types/PyTypeParser", "getTypeByName"));
        }
        return PyTypeParser.parse(anchor, type).getType();
    }

    @NotNull
    public static ParseResult parse(final @Nullable PsiElement anchor, @NotNull String type) {
        ParseResult parseResult;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/types/PyTypeParser", "parse"));
        }
        if (anchor == null || !anchor.isValid()) {
            ParseResult parseResult2 = EMPTY_RESULT;
            if (parseResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeParser", "parse"));
            }
            return parseResult2;
        }
        ForwardDeclaration<ParseResult, PyElementType> typeExpr = ForwardDeclaration.create();
        FunctionalParser<ParseResult, PyElementType> classType = FunctionalParserBase.token(PyTypeTokenTypes.IDENTIFIER).then(FunctionalParserBase.many(PyTypeParser.op(".").skipThen(FunctionalParserBase.token(PyTypeTokenTypes.IDENTIFIER)))).map(new MakeSimpleType(anchor)).cached().named("class-type");
        FunctionalParser<ParseResult, PyElementType> tupleType = PyTypeParser.op("(").skipThen(typeExpr).then(FunctionalParserBase.many(PyTypeParser.op(",").skipThen(typeExpr))).thenSkip(PyTypeParser.op(")")).map(new Function<Pair<ParseResult, List<ParseResult>>, ParseResult>(){

            public ParseResult fun(Pair<ParseResult, List<ParseResult>> value) {
                ParseResult result = (ParseResult)value.getFirst();
                List rest = (List)value.getSecond();
                if (rest.isEmpty()) {
                    return result;
                }
                ArrayList<PyType> types = new ArrayList<PyType>();
                types.add(result.getType());
                for (ParseResult r : rest) {
                    result = result.merge(r);
                    types.add(r.getType());
                }
                return result.withType(PyTupleType.create(anchor, types.toArray(new PyType[types.size()])));
            }
        }).named("tuple-type");
        FunctionalParser<ParseResult, PyElementType> typeParameter = FunctionalParserBase.token(PyTypeTokenTypes.PARAMETER).then(FunctionalParserBase.maybe(PyTypeParser.op("<=").skipThen(typeExpr))).map(new Function<Pair<Token<PyElementType>, ParseResult>, ParseResult>(){

            public ParseResult fun(Pair<Token<PyElementType>, ParseResult> value) {
                Token token = (Token)value.getFirst();
                String name = ((Object)token.getText()).toString();
                TextRange range = token.getRange();
                ParseResult boundResult = (ParseResult)value.getSecond();
                if (boundResult != null) {
                    PyGenericType type = new PyGenericType(name, boundResult.getType());
                    ParseResult result = new ParseResult(type, range);
                    return result.merge(boundResult).withType(type);
                }
                return new ParseResult(new PyGenericType(name, null), range);
            }
        }).named("type-parameter");
        FunctionalParser<ParseResult, PyElementType> simpleExpr = classType.or(tupleType).or(typeParameter).named("simple-expr");
        FunctionalParser<ParseResult, PyElementType> paramExpr = classType.thenSkip(PyTypeParser.op("[")).then(typeExpr).then(FunctionalParserBase.many(PyTypeParser.op(",").skipThen(typeExpr))).thenSkip(PyTypeParser.op("]")).map(new Function<Pair<Pair<ParseResult, ParseResult>, List<ParseResult>>, ParseResult>(){

            public ParseResult fun(Pair<Pair<ParseResult, ParseResult>, List<ParseResult>> value) {
                Pair firstPair = (Pair)value.getFirst();
                ParseResult first = (ParseResult)firstPair.getFirst();
                ParseResult second = (ParseResult)firstPair.getSecond();
                List third = (List)value.getSecond();
                PyType firstType = first.getType();
                if (firstType instanceof PyClassType) {
                    ArrayList<PyType> tupleTypes = new ArrayList<PyType>();
                    tupleTypes.add(second.getType());
                    ParseResult result = first;
                    result = result.merge(second);
                    for (ParseResult r : third) {
                        tupleTypes.add(r.getType());
                        result = result.merge(r);
                    }
                    PyType elementType = third.isEmpty() ? second.getType() : PyTupleType.create(anchor, tupleTypes.toArray(new PyType[tupleTypes.size()]));
                    PyCollectionTypeImpl type = new PyCollectionTypeImpl(((PyClassType)firstType).getPyClass(), false, elementType);
                    return result.withType(type);
                }
                return EMPTY_RESULT;
            }
        }).or(classType.thenSkip(PyTypeParser.op("of")).then(simpleExpr).map(new Function<Pair<ParseResult, ParseResult>, ParseResult>(){

            public ParseResult fun(Pair<ParseResult, ParseResult> value) {
                ParseResult firstResult = (ParseResult)value.getFirst();
                ParseResult secondResult = (ParseResult)value.getSecond();
                ParseResult result = firstResult.merge(secondResult);
                PyType firstType = firstResult.getType();
                PyType secondType = secondResult.getType();
                if (firstType != null) {
                    if (firstType instanceof PyClassType && secondType != null) {
                        return result.withType(new PyCollectionTypeImpl(((PyClassType)firstType).getPyClass(), false, secondType));
                    }
                    return result.withType(firstType);
                }
                return EMPTY_RESULT;
            }
        })).or(classType.thenSkip(PyTypeParser.op("from")).then(simpleExpr).thenSkip(PyTypeParser.op("to")).then(simpleExpr).map(new Function<Pair<Pair<ParseResult, ParseResult>, ParseResult>, ParseResult>(){

            public ParseResult fun(Pair<Pair<ParseResult, ParseResult>, ParseResult> value) {
                Pair firstPair = (Pair)value.getFirst();
                ParseResult first = (ParseResult)firstPair.getFirst();
                ParseResult second = (ParseResult)firstPair.getSecond();
                ParseResult third = (ParseResult)value.getSecond();
                PyType firstType = first.getType();
                if (firstType instanceof PyClassType) {
                    PyTupleType tupleType = PyTupleType.create(anchor, new PyType[]{second.getType(), third.getType()});
                    PyCollectionTypeImpl type = new PyCollectionTypeImpl(((PyClassType)firstType).getPyClass(), false, tupleType);
                    return first.merge(second).merge(third).withType(type);
                }
                return EMPTY_RESULT;
            }
        })).named("param-expr");
        FunctionalParser<ParseResult, PyElementType> callableExpr = PyTypeParser.op("(").skipThen(FunctionalParserBase.maybe(typeExpr.then(FunctionalParserBase.many(PyTypeParser.op(",").skipThen(typeExpr))))).thenSkip(PyTypeParser.op(")")).thenSkip(PyTypeParser.op("->")).then(typeExpr).map(new Function<Pair<Pair<ParseResult, List<ParseResult>>, ParseResult>, ParseResult>(){

            public ParseResult fun(Pair<Pair<ParseResult, List<ParseResult>>, ParseResult> value) {
                ParseResult result;
                ArrayList<PyCallableParameter> parameters = new ArrayList<PyCallableParameter>();
                ParseResult returnResult = (ParseResult)value.getSecond();
                Pair firstPair = (Pair)value.getFirst();
                if (firstPair != null) {
                    ParseResult first = (ParseResult)firstPair.getFirst();
                    List second = (List)firstPair.getSecond();
                    result = first;
                    parameters.add(new PyCallableParameterImpl(null, first.getType()));
                    for (ParseResult r : second) {
                        result = result.merge(r);
                        parameters.add(new PyCallableParameterImpl(null, r.getType()));
                    }
                    result = result.merge(returnResult);
                } else {
                    result = returnResult;
                }
                return result.withType(new PyCallableTypeImpl(parameters, returnResult.getType()));
            }
        }).named("callable-expr");
        FunctionalParser<ParseResult, PyElementType> singleExpr = paramExpr.or(callableExpr).or(simpleExpr).named("single-expr");
        FunctionalParser<ParseResult, PyElementType> unionExpr = singleExpr.then(FunctionalParserBase.many(PyTypeParser.op("or").or(PyTypeParser.op("|")).skipThen(singleExpr))).map(new Function<Pair<ParseResult, List<ParseResult>>, ParseResult>(){

            public ParseResult fun(Pair<ParseResult, List<ParseResult>> value) {
                ParseResult first = (ParseResult)value.getFirst();
                List rest = (List)value.getSecond();
                if (rest.isEmpty()) {
                    return first;
                }
                ArrayList<PyType> types = new ArrayList<PyType>();
                types.add(first.getType());
                ParseResult result = first;
                for (ParseResult r : rest) {
                    types.add(r.getType());
                    result = result.merge(r);
                }
                return result.withType(PyUnionType.union(types));
            }
        }).named("union-expr");
        typeExpr.define(unionExpr).named("type-expr");
        FunctionalParser typeFile = typeExpr.endOfInput().named("type-file");
        try {
            parseResult = (ParseResult)typeFile.parse(PyTypeParser.tokenize(type));
        }
        catch (ParserException e) {
            ParseResult parseResult3 = EMPTY_RESULT;
            if (parseResult3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeParser", "parse"));
            }
            return parseResult3;
        }
        if (parseResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeParser", "parse"));
        }
        return parseResult;
    }

    private static FunctionalParser<Token<PyElementType>, PyElementType> op(@Nullable String text) {
        return FunctionalParserBase.token(PyTypeTokenTypes.OP, text);
    }

    private static List<Token<PyElementType>> tokenize(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/psi/types/PyTypeParser", "tokenize"));
        }
        ArrayList<Token<PyElementType>> tokens = new ArrayList<Token<PyElementType>>();
        PyTypeLexer lexer = new PyTypeLexer(new StringReader(s));
        lexer.reset(s, 0, s.length(), lexer.yystate());
        try {
            PyElementType type;
            while ((type = lexer.advance()) != null) {
                if (type == PyTypeTokenTypes.SPACE || type == PyTypeTokenTypes.MARKUP) continue;
                TextRange range = TextRange.create((int)lexer.getTokenStart(), (int)lexer.getTokenEnd());
                Token<PyElementType> token = new Token<PyElementType>(type, lexer.yytext(), range);
                tokens.add(token);
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        catch (Error e) {
            return Collections.emptyList();
        }
        return tokens;
    }

    private static class MakeSimpleType
    implements Function<Pair<Token<PyElementType>, List<Token<PyElementType>>>, ParseResult> {
        @NotNull
        private final PsiElement myAnchor;

        public MakeSimpleType(@NotNull PsiElement anchor) {
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "<init>"));
            }
            this.myAnchor = anchor;
        }

        @Nullable
        public ParseResult fun(@NotNull Pair<Token<PyElementType>, List<Token<PyElementType>>> value) {
            HashMap imports;
            HashMap fullRanges;
            HashMap types;
            TypeEvalContext context;
            PyFile pyFile;
            PyType type;
            ParseResult result;
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "fun"));
            }
            Token first = (Token)value.getFirst();
            List rest = (List)value.getSecond();
            TextRange firstRange = first.getRange();
            boolean unqualified = rest.isEmpty();
            if (unqualified && (result = this.parseBuiltinType(first)) != null) {
                return result;
            }
            PsiFile file = this.myAnchor.getContainingFile();
            ArrayList<Token<PyElementType>> tokens = new ArrayList<Token<PyElementType>>();
            tokens.add(first);
            tokens.addAll(rest);
            if (file instanceof PyFile && (type = this.resolveQualifierType(tokens, pyFile = (PyFile)file, context = TypeEvalContext.codeInsightFallback(file.getProject()), (Map<TextRange, PyType>)(types = new HashMap()), (Map<PyType, TextRange>)(fullRanges = new HashMap()), (Map<PyType, PyImportElement>)(imports = new HashMap()))) != null) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
                PyExpression expression = this.myAnchor instanceof PyExpression ? (PyExpression)this.myAnchor : null;
                for (Token token : tokens) {
                    PsiElement resolved;
                    PyType qualifierType = type;
                    type = null;
                    List<? extends RatedResolveResult> results = qualifierType.resolveMember(((Object)token.getText()).toString(), expression, AccessDirection.READ, resolveContext);
                    if (results != null && !results.isEmpty() && (resolved = results.get(0).getElement()) instanceof PyTypedElement) {
                        type = context.getType((PyTypedElement)resolved);
                        if (type != null && !MakeSimpleType.allowResolveToType(type)) {
                            type = null;
                            break;
                        }
                        if (type instanceof PyClassLikeType) {
                            type = ((PyClassLikeType)type).toInstance();
                        }
                    }
                    if (type == null) break;
                    types.put(token.getRange(), type);
                    fullRanges.put(type, TextRange.create((int)firstRange.getStartOffset(), (int)token.getRange().getEndOffset()));
                }
                if (type != null) {
                    return new ParseResult(type, (Map<TextRange, ? extends PyType>)types, (Map<? extends PyType, TextRange>)fullRanges, (Map<? extends PyType, PyImportElement>)imports);
                }
            }
            return EMPTY_RESULT;
        }

        @Nullable
        private PyType resolveQualifierType(@NotNull List<Token<PyElementType>> tokens, @NotNull PyFile file, @NotNull TypeEvalContext context, @NotNull Map<TextRange, PyType> types, @NotNull Map<PyType, TextRange> fullRanges, @NotNull Map<PyType, PyImportElement> imports) {
            PyType type;
            block16: {
                TextRange firstRange;
                block17: {
                    if (tokens == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "resolveQualifierType"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "resolveQualifierType"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "resolveQualifierType"));
                    }
                    if (types == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "resolveQualifierType"));
                    }
                    if (fullRanges == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRanges", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "resolveQualifierType"));
                    }
                    if (imports == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "resolveQualifierType"));
                    }
                    if (tokens.isEmpty()) {
                        return null;
                    }
                    Token<PyElementType> firstToken = tokens.get(0);
                    String firstText = ((Object)firstToken.getText()).toString();
                    firstRange = firstToken.getRange();
                    type = null;
                    PsiElement resolved = file.getElementNamed(firstText);
                    if (resolved == null) break block17;
                    if (!(resolved instanceof PyTypedElement) || (type = context.getType((PyTypedElement)resolved)) == null) break block16;
                    tokens.remove(0);
                    if (!MakeSimpleType.allowResolveToType(type)) {
                        return null;
                    }
                    if (type instanceof PyClassLikeType) {
                        type = ((PyClassLikeType)type).toInstance();
                    }
                    types.put(firstRange, type);
                    fullRanges.put(type, firstRange);
                    for (PyFromImportStatement fromImportStatement : file.getFromImports()) {
                        for (PyImportElement importElement : fromImportStatement.getImportElements()) {
                            if (!firstText.equals(importElement.getVisibleName())) continue;
                            imports.put(type, importElement);
                        }
                    }
                    for (PyImportElement importElement : file.getImportTargets()) {
                        if (!firstText.equals(importElement.getVisibleName())) continue;
                        imports.put(type, importElement);
                    }
                    break block16;
                }
                QualifiedName qName = null;
                while (!tokens.isEmpty()) {
                    Token<PyElementType> token = tokens.get(0);
                    String name = ((Object)token.getText()).toString();
                    PsiElement module = new QualifiedNameResolverImpl(qName = qName != null ? qName.append(name) : QualifiedName.fromComponents((String[])new String[]{name})).fromElement(this.myAnchor).firstResult();
                    if (module != null) {
                        PyType moduleType;
                        if (module instanceof PsiDirectory) {
                            module = PyUtil.getPackageElement((PsiDirectory)module, this.myAnchor);
                        }
                        if (module instanceof PyTypedElement && (moduleType = context.getType((PyTypedElement)module)) != null) {
                            type = moduleType;
                            types.put(token.getRange(), type);
                            fullRanges.put(type, TextRange.create((int)firstRange.getStartOffset(), (int)token.getRange().getEndOffset()));
                        }
                        tokens.remove(0);
                        continue;
                    }
                    break;
                }
            }
            return type;
        }

        private static boolean allowResolveToType(@NotNull PyType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "allowResolveToType"));
            }
            return type instanceof PyClassLikeType || type instanceof PyModuleType || type instanceof PyImportedModuleType;
        }

        @Nullable
        private ParseResult parseBuiltinType(@NotNull Token<PyElementType> token) {
            if (token == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/jetbrains/python/psi/types/PyTypeParser$MakeSimpleType", "parseBuiltinType"));
            }
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(this.myAnchor);
            String name = ((Object)token.getText()).toString();
            TextRange range = token.getRange();
            if ("unknown".equals(name)) {
                return EMPTY_RESULT;
            }
            if ("None".equals(name)) {
                return new ParseResult(PyNoneType.INSTANCE, range);
            }
            if ("integer".equals(name) || "long".equals(name) && LanguageLevel.forElement(this.myAnchor).isPy3K()) {
                PyClassType type = builtinCache.getIntType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("string".equals(name)) {
                PyType type = builtinCache.getStringType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("bytestring".equals(name)) {
                PyType type = builtinCache.getByteStringType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("bytes".equals(name)) {
                PyClassType type = builtinCache.getBytesType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("unicode".equals(name)) {
                PyClassType type = builtinCache.getUnicodeType(LanguageLevel.forElement(this.myAnchor));
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("boolean".equals(name)) {
                PyClassType type = builtinCache.getBoolType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            if ("dictionary".equals(name)) {
                PyClassType type = builtinCache.getDictType();
                return type != null ? new ParseResult(type, range) : EMPTY_RESULT;
            }
            PyClassTypeImpl builtinType = builtinCache.getObjectType(name);
            if (builtinType != null) {
                return new ParseResult(builtinType, range);
            }
            return null;
        }
    }

    public static class ParseResult {
        @Nullable
        private PyType myType;
        @NotNull
        private Map<TextRange, ? extends PyType> myTypes;
        @NotNull
        private Map<? extends PyType, TextRange> myFullRanges;
        @NotNull
        private final Map<? extends PyType, PyImportElement> myImports;

        ParseResult(@Nullable PyType type, @NotNull Map<TextRange, ? extends PyType> types, @NotNull Map<? extends PyType, TextRange> fullRanges, @NotNull Map<? extends PyType, PyImportElement> imports) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "<init>"));
            }
            if (fullRanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRanges", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "<init>"));
            }
            if (imports == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "<init>"));
            }
            this.myType = type;
            this.myTypes = types;
            this.myFullRanges = fullRanges;
            this.myImports = imports;
        }

        ParseResult(@NotNull PyType type, @NotNull TextRange range) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "<init>"));
            }
            this(type, (Map<TextRange, ? extends PyType>)ImmutableMap.of((Object)range, (Object)type), (Map<? extends PyType, TextRange>)ImmutableMap.of((Object)type, (Object)range), (Map<? extends PyType, PyImportElement>)ImmutableMap.of());
        }

        @Nullable
        public PyType getType() {
            return this.myType;
        }

        @NotNull
        public Map<TextRange, ? extends PyType> getTypes() {
            Map<TextRange, ? extends PyType> map = this.myTypes;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "getTypes"));
            }
            return map;
        }

        @NotNull
        public Map<? extends PyType, TextRange> getFullRanges() {
            Map<? extends PyType, TextRange> map = this.myFullRanges;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "getFullRanges"));
            }
            return map;
        }

        @NotNull
        public Map<? extends PyType, PyImportElement> getImports() {
            Map<? extends PyType, PyImportElement> map = this.myImports;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "getImports"));
            }
            return map;
        }

        private ParseResult merge(@NotNull ParseResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/psi/types/PyTypeParser$ParseResult", "merge"));
            }
            HashMap types = new HashMap();
            HashMap fullRanges = new HashMap();
            HashMap imports = new HashMap();
            types.putAll(this.myTypes);
            types.putAll(result.getTypes());
            fullRanges.putAll(this.myFullRanges);
            fullRanges.putAll(result.getFullRanges());
            imports.putAll(this.myImports);
            imports.putAll(result.getImports());
            return new ParseResult(this.myType, (Map<TextRange, ? extends PyType>)types, (Map<? extends PyType, TextRange>)fullRanges, (Map<? extends PyType, PyImportElement>)imports);
        }

        private ParseResult withType(@Nullable PyType type) {
            return new ParseResult(type, this.myTypes, this.myFullRanges, this.myImports);
        }
    }
}

