/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "match"));
        }
        return PyTypeChecker.match(expected, actual, context, null, true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @Nullable Map<PyGenericType, PyType> substitutions) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "match"));
        }
        return PyTypeChecker.match(expected, actual, context, substitutions, true);
    }

    private static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @Nullable Map<PyGenericType, PyType> substitutions, boolean recursive) {
        PyClass superClass;
        PyClass c;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "match"));
        }
        if (expected instanceof PyGenericType && substitutions != null) {
            PyGenericType generic = (PyGenericType)expected;
            PyType subst = substitutions.get(generic);
            PyType bound = generic.getBound();
            if (!PyTypeChecker.match(bound, actual, context, substitutions, recursive)) {
                return false;
            }
            if (subst != null) {
                if (expected.equals(actual)) {
                    return true;
                }
                if (recursive) {
                    return PyTypeChecker.match(subst, actual, context, substitutions, false);
                }
                return false;
            }
            if (actual != null) {
                substitutions.put(generic, actual);
            } else if (bound != null) {
                substitutions.put(generic, bound);
            }
            return true;
        }
        if (expected == null || actual == null) {
            return true;
        }
        if (expected instanceof PyClassType && "object".equals((c = ((PyClassType)expected).getPyClass()).getName())) {
            return true;
        }
        if (PyTypeChecker.isUnknown(actual)) {
            return true;
        }
        if (actual instanceof PyUnionType) {
            for (PyType m : ((PyUnionType)actual).getMembers()) {
                if (!PyTypeChecker.match(expected, m, context, substitutions, recursive)) continue;
                return true;
            }
            return false;
        }
        if (expected instanceof PyUnionType) {
            for (PyType t : ((PyUnionType)expected).getMembers()) {
                if (!PyTypeChecker.match(t, actual, context, substitutions, recursive)) continue;
                return true;
            }
            return false;
        }
        if (expected instanceof PyClassType && actual instanceof PyClassType) {
            superClass = ((PyClassType)expected).getPyClass();
            PyClass subClass = ((PyClassType)actual).getPyClass();
            if (expected instanceof PyCollectionType && actual instanceof PyCollectionType) {
                if (!PyTypeChecker.matchClasses(superClass, subClass, context)) {
                    return false;
                }
                PyType superElementType = ((PyCollectionType)expected).getElementType(context);
                PyType subElementType = ((PyCollectionType)actual).getElementType(context);
                return PyTypeChecker.match(superElementType, subElementType, context, substitutions, recursive);
            }
            if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
                PyTupleType superTupleType = (PyTupleType)expected;
                PyTupleType subTupleType = (PyTupleType)actual;
                if (superTupleType.getElementCount() != subTupleType.getElementCount()) {
                    return false;
                }
                for (int i = 0; i < superTupleType.getElementCount(); ++i) {
                    if (PyTypeChecker.match(superTupleType.getElementType(i), subTupleType.getElementType(i), context, substitutions, recursive)) continue;
                    return false;
                }
                return true;
            }
            if (PyTypeChecker.matchClasses(superClass, subClass, context)) {
                return true;
            }
            if (((PyClassType)actual).isDefinition() && "Callable".equals(expected.getName())) {
                return true;
            }
            if (expected.equals(actual)) {
                return true;
            }
        }
        if (actual instanceof PyFunctionType && expected instanceof PyClassType && "Callable".equals((superClass = ((PyClassType)expected).getPyClass()).getName())) {
            return true;
        }
        if (actual instanceof PyCallableType && expected instanceof PyCallableType) {
            PyCallableType expectedCallable = (PyCallableType)expected;
            PyCallableType actualCallable = (PyCallableType)actual;
            if (expectedCallable.isCallable() && actualCallable.isCallable()) {
                List<PyCallableParameter> expectedParameters = expectedCallable.getParameters(context);
                List<PyCallableParameter> actualParameters = actualCallable.getParameters(context);
                if (expectedParameters != null && actualParameters != null) {
                    int size = Math.min(expectedParameters.size(), actualParameters.size());
                    for (int i = 0; i < size; ++i) {
                        PyCallableParameter expectedParam = expectedParameters.get(i);
                        PyCallableParameter actualParam = actualParameters.get(i);
                        if (PyTypeChecker.match(expectedParam.getType(context), actualParam.getType(context), context, substitutions, recursive)) continue;
                        return false;
                    }
                }
                return PyTypeChecker.match(expectedCallable.getReturnType(context), actualCallable.getReturnType(context), context, substitutions, recursive);
            }
        }
        return PyTypeChecker.matchNumericTypes(expected, actual);
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        String superName = expected.getName();
        String subName = actual.getName();
        boolean subIsBool = "bool".equals(subName);
        boolean subIsInt = "int".equals(subName);
        boolean subIsLong = "long".equals(subName);
        boolean subIsFloat = "float".equals(subName);
        boolean subIsComplex = "complex".equals(subName);
        return !(superName != null && subName != null && !superName.equals(subName) && (!"int".equals(superName) || !subIsBool) && (!"long".equals(superName) && !"Integral".equals(superName) || !subIsBool && !subIsInt) && (!"float".equals(superName) && !"Real".equals(superName) || !subIsBool && !subIsInt && !subIsLong) && (!"complex".equals(superName) && !"Complex".equals(superName) || !subIsBool && !subIsInt && !subIsLong && !subIsFloat) && (!"Number".equals(superName) || !subIsBool && !subIsInt && !subIsLong && !subIsFloat && !subIsComplex));
    }

    public static boolean isUnknown(@Nullable PyType type) {
        if (type == null || type instanceof PyGenericType) {
            return true;
        }
        if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                if (!PyTypeChecker.isUnknown(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PyType toNonWeakType(@Nullable PyType type, @NotNull TypeEvalContext context) {
        PyUnionType unionType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "toNonWeakType"));
        }
        if (type instanceof PyUnionType && (unionType = (PyUnionType)type).isWeak()) {
            return unionType.excludeNull(context);
        }
        return type;
    }

    public static boolean hasGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "hasGenerics"));
        }
        HashSet<PyGenericType> collected = new HashSet<PyGenericType>();
        PyTypeChecker.collectGenerics(type, context, collected, new HashSet<PyType>());
        return !collected.isEmpty();
    }

    private static void collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull Set<PyGenericType> collected, @NotNull Set<PyType> visited) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "collectGenerics"));
        }
        if (collected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collected", "com/jetbrains/python/psi/types/PyTypeChecker", "collectGenerics"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/python/psi/types/PyTypeChecker", "collectGenerics"));
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        if (type instanceof PyGenericType) {
            collected.add((PyGenericType)type);
        } else if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                PyTypeChecker.collectGenerics(t, context, collected, visited);
            }
        } else if (type instanceof PyCollectionType) {
            PyCollectionType collection = (PyCollectionType)type;
            PyTypeChecker.collectGenerics(collection.getElementType(context), context, collected, visited);
        } else if (type instanceof PyTupleType) {
            PyTupleType tuple = (PyTupleType)type;
            int n = tuple.getElementCount();
            for (int i = 0; i < n; ++i) {
                PyTypeChecker.collectGenerics(tuple.getElementType(i), context, collected, visited);
            }
        } else if (type instanceof PyCallableType) {
            PyCallableType callable = (PyCallableType)type;
            List<PyCallableParameter> parameters = callable.getParameters(context);
            if (parameters != null) {
                for (PyCallableParameter parameter : parameters) {
                    if (parameter == null) continue;
                    PyTypeChecker.collectGenerics(parameter.getType(context), context, collected, visited);
                }
            }
            PyTypeChecker.collectGenerics(callable.getReturnType(context), context, collected, visited);
        }
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/psi/types/PyTypeChecker", "substitute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "substitute"));
        }
        if (PyTypeChecker.hasGenerics(type, context)) {
            if (type instanceof PyGenericType) {
                return substitutions.get((PyGenericType)type);
            }
            if (type instanceof PyUnionType) {
                PyUnionType union = (PyUnionType)type;
                ArrayList<PyType> results = new ArrayList<PyType>();
                for (PyType t : union.getMembers()) {
                    PyType subst = PyTypeChecker.substitute(t, substitutions, context);
                    results.add(subst);
                }
                return PyUnionType.union(results);
            }
            if (type instanceof PyCollectionTypeImpl) {
                PyCollectionTypeImpl collection = (PyCollectionTypeImpl)type;
                PyType elem = collection.getElementType(context);
                PyType subst = PyTypeChecker.substitute(elem, substitutions, context);
                return new PyCollectionTypeImpl(collection.getPyClass(), collection.isDefinition(), subst);
            }
            if (type instanceof PyTupleType) {
                PyTupleType tuple = (PyTupleType)type;
                int n = tuple.getElementCount();
                ArrayList<PyType> results = new ArrayList<PyType>();
                for (int i = 0; i < n; ++i) {
                    PyType subst = PyTypeChecker.substitute(tuple.getElementType(i), substitutions, context);
                    results.add(subst);
                }
                return new PyTupleType((PyTupleType)type, results.toArray(new PyType[results.size()]));
            }
            if (type instanceof PyCallableType) {
                PyCallableType callable = (PyCallableType)type;
                ArrayList<PyCallableParameter> substParams = null;
                List<PyCallableParameter> parameters = callable.getParameters(context);
                if (parameters != null) {
                    substParams = new ArrayList<PyCallableParameter>();
                    for (PyCallableParameter parameter : parameters) {
                        PyType substType = PyTypeChecker.substitute(parameter.getType(context), substitutions, context);
                        PyCallableParameterImpl subst = parameter.getParameter() != null ? new PyCallableParameterImpl(parameter.getParameter()) : new PyCallableParameterImpl(parameter.getName(), substType);
                        substParams.add(subst);
                    }
                }
                PyType substResult = PyTypeChecker.substitute(callable.getReturnType(context), substitutions, context);
                return new PyCallableTypeImpl(substParams, substResult);
            }
        }
        return type;
    }

    @Nullable
    public static Map<PyGenericType, PyType> unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyNamedParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/python/psi/types/PyTypeChecker", "unifyGenericCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "unifyGenericCall"));
        }
        Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyReceiver(receiver, context);
        for (Map.Entry<PyExpression, PyNamedParameter> entry : arguments.entrySet()) {
            PyNamedParameter p = entry.getValue();
            if (p.isPositionalContainer() || p.isKeywordContainer()) continue;
            PyType argType = context.getType(entry.getKey());
            PyType paramType = context.getType(p);
            if (PyTypeChecker.match(paramType, argType, context, substitutions)) continue;
            return null;
        }
        return substitutions;
    }

    @NotNull
    public static Map<PyGenericType, PyType> unifyReceiver(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        PyType initReturnType;
        PyType initType;
        PsiElement init;
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "unifyReceiver"));
        }
        LinkedHashMap<PyGenericType, PyType> substitutions = new LinkedHashMap<PyGenericType, PyType>();
        LinkedHashSet<PyGenericType> generics = new LinkedHashSet<PyGenericType>();
        PyType qualifierType = receiver != null ? context.getType(receiver) : null;
        PyTypeChecker.collectGenerics(qualifierType, context, generics, new HashSet<PyType>());
        for (PyGenericType t : generics) {
            substitutions.put(t, t);
        }
        if (qualifierType != null && (results = qualifierType.resolveMember("__init__", null, AccessDirection.READ, resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context))) != null && !results.isEmpty() && (init = results.get(0).getElement()) instanceof PyTypedElement && (initType = context.getType((PyTypedElement)init)) instanceof PyCallableType && (initReturnType = ((PyCallableType)initType).getReturnType(context)) != null) {
            PyTypeChecker.match(initReturnType, qualifierType, context, substitutions);
        }
        LinkedHashMap<PyGenericType, PyType> linkedHashMap = substitutions;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeChecker", "unifyReceiver"));
        }
        return linkedHashMap;
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "matchClasses"));
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass) || PyABCUtil.isSubclass(subClass, superClass)) {
            return true;
        }
        if (PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    @Nullable
    public static AnalyzeCallResults analyzeCall(@NotNull PyCallExpression call, @NotNull TypeEvalContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCall"));
        }
        PyExpression callee = call.getCallee();
        PyArgumentList args = call.getArgumentList();
        if (args != null) {
            Callable callable;
            CallArgumentsMapping mapping = args.analyzeCall(PyResolveContext.noImplicits().withTypeEvalContext(context));
            Map<PyExpression, PyNamedParameter> arguments = mapping.getPlainMappedParams();
            PyCallExpression.PyMarkedCallee markedCallee = mapping.getMarkedCallee();
            if (markedCallee != null && (callable = markedCallee.getCallable()) instanceof PyFunction) {
                PyFunction function = (PyFunction)callable;
                PyExpression receiver = function.getModifier() == PyFunction.Modifier.STATICMETHOD ? null : (callee instanceof PyQualifiedExpression ? ((PyQualifiedExpression)callee).getQualifier() : null);
                return new AnalyzeCallResults(callable, receiver, arguments);
            }
        }
        return null;
    }

    @Nullable
    public static AnalyzeCallResults analyzeCall(@NotNull PyBinaryExpression expr, @NotNull TypeEvalContext context) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCall"));
        }
        PsiPolyVariantReference ref = expr.getReference(PyResolveContext.noImplicits().withTypeEvalContext(context));
        ResolveResult[] resolveResult = ref.multiResolve(false);
        AnalyzeCallResults firstResults = null;
        for (ResolveResult result : resolveResult) {
            PsiElement resolved = result.getElement();
            if (!(resolved instanceof PyTypedElement)) continue;
            PyTypedElement typedElement = (PyTypedElement)resolved;
            PyType type = context.getType(typedElement);
            if (!(type instanceof PyFunctionType)) {
                return null;
            }
            Callable callable = ((PyFunctionType)type).getCallable();
            String operatorName = typedElement.getName();
            boolean isRight = PyNames.isRightOperatorName(operatorName) || "__contains__".equals(operatorName);
            PyExpression arg = isRight ? expr.getLeftExpression() : expr.getRightExpression();
            PyExpression receiver = isRight ? expr.getRightExpression() : expr.getLeftExpression();
            PyParameter[] parameters = callable.getParameterList().getParameters();
            if (parameters.length < 2) continue;
            PyNamedParameter param = parameters[1].getAsNamed();
            if (arg == null || param == null) continue;
            LinkedHashMap<PyExpression, PyNamedParameter> arguments = new LinkedHashMap<PyExpression, PyNamedParameter>();
            arguments.put(arg, param);
            AnalyzeCallResults results = new AnalyzeCallResults(callable, receiver, arguments);
            if (firstResults == null) {
                firstResults = results;
            }
            if (!PyTypeChecker.match(context.getType(param), context.getType(arg), context)) continue;
            return results;
        }
        if (firstResults != null) {
            return firstResults;
        }
        return null;
    }

    @Nullable
    public static AnalyzeCallResults analyzeCall(@NotNull PySubscriptionExpression expr, @NotNull TypeEvalContext context) {
        PyNamedParameter param;
        Callable callable;
        PyParameter[] parameters;
        PyType type;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCall"));
        }
        PsiPolyVariantReference ref = expr.getReference(PyResolveContext.noImplicits().withTypeEvalContext(context));
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PyTypedElement && (type = context.getType((PyTypedElement)resolved)) instanceof PyFunctionType && (parameters = (callable = ((PyFunctionType)type).getCallable()).getParameterList().getParameters()).length == 2 && (param = parameters[1].getAsNamed()) != null) {
            LinkedHashMap<PyExpression, PyNamedParameter> arguments = new LinkedHashMap<PyExpression, PyNamedParameter>();
            PyExpression arg = expr.getIndexExpression();
            if (arg != null) {
                arguments.put(arg, param);
                return new AnalyzeCallResults(callable, expr.getOperand(), arguments);
            }
        }
        return null;
    }

    @Nullable
    public static AnalyzeCallResults analyzeCallSite(@Nullable PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyTypeChecker", "analyzeCallSite"));
        }
        if (callSite instanceof PyCallExpression) {
            return PyTypeChecker.analyzeCall((PyCallExpression)callSite, context);
        }
        if (callSite instanceof PyBinaryExpression) {
            return PyTypeChecker.analyzeCall((PyBinaryExpression)callSite, context);
        }
        if (callSite instanceof PySubscriptionExpression) {
            return PyTypeChecker.analyzeCall((PySubscriptionExpression)callSite, context);
        }
        return null;
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType) {
            Boolean result = true;
            for (PyType member : ((PyUnionType)type).getMembers()) {
                Boolean callable = PyTypeChecker.isCallable(member);
                if (callable == null) {
                    return null;
                }
                if (callable.booleanValue()) continue;
                result = false;
            }
            return result;
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).isCallable();
        }
        return false;
    }

    public static class AnalyzeCallResults {
        @NotNull
        private final Callable myCallable;
        @Nullable
        private final PyExpression myReceiver;
        @NotNull
        private final Map<PyExpression, PyNamedParameter> myArguments;

        public AnalyzeCallResults(@NotNull Callable callable, @Nullable PyExpression receiver, @NotNull Map<PyExpression, PyNamedParameter> arguments) {
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/types/PyTypeChecker$AnalyzeCallResults", "<init>"));
            }
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/python/psi/types/PyTypeChecker$AnalyzeCallResults", "<init>"));
            }
            this.myCallable = callable;
            this.myReceiver = receiver;
            this.myArguments = arguments;
        }

        @NotNull
        public Callable getCallable() {
            Callable callable = this.myCallable;
            if (callable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeChecker$AnalyzeCallResults", "getCallable"));
            }
            return callable;
        }

        @Nullable
        public PyExpression getReceiver() {
            return this.myReceiver;
        }

        @NotNull
        public Map<PyExpression, PyNamedParameter> getArguments() {
            Map<PyExpression, PyNamedParameter> map = this.myArguments;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyTypeChecker$AnalyzeCallResults", "getArguments"));
            }
            return map;
        }
    }
}

