/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyConstantExpressionEvaluator;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PySubscriptableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTupleType
extends PyClassTypeImpl
implements PySubscriptableType {
    private final PyType[] myElementTypes;

    PyTupleType(@NotNull PyClass tupleClass, PsiElement anchor, PyType[] elementTypes) {
        if (tupleClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tupleClass", "com/jetbrains/python/psi/types/PyTupleType", "<init>"));
        }
        super(tupleClass, false);
        this.myElementTypes = elementTypes;
    }

    @Nullable
    public static PyTupleType create(PsiElement anchor, PyType[] elementTypes) {
        PyClass tuple = PyBuiltinCache.getInstance(anchor).getClass("tuple");
        if (tuple != null) {
            return new PyTupleType(tuple, anchor, elementTypes);
        }
        return null;
    }

    public PyTupleType(PyTupleType origin, PyType[] elementTypes) {
        super(origin.getPyClass(), false);
        this.myElementTypes = elementTypes;
    }

    @Override
    public String getName() {
        return "(" + StringUtil.join((Object[])this.myElementTypes, (Function)new Function<PyType, String>(){

            @Nullable
            public String fun(PyType pyType) {
                return pyType == null ? "unknown" : pyType.getName();
            }
        }, (String)", ") + ")";
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public PyType getElementType(PyExpression index, TypeEvalContext context) {
        Object value = PyConstantExpressionEvaluator.evaluate(index);
        if (value instanceof Integer) {
            return this.getElementType((Integer)value);
        }
        return null;
    }

    @Override
    public PyType getElementType(int index) {
        if (index >= 0 && index < this.myElementTypes.length) {
            return this.myElementTypes[index];
        }
        return null;
    }

    @Override
    public int getElementCount() {
        return this.myElementTypes.length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyTupleType that = (PyTupleType)o;
        return Arrays.equals(this.myElementTypes, that.myElementTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myElementTypes != null ? Arrays.hashCode(this.myElementTypes) : 0);
        return result;
    }
}

