/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingModuleMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyModuleType
implements PyType {
    @NotNull
    private final PyFile myModule;
    @Nullable
    private final PyImportedModule myImportedModule;
    public static final ImmutableSet<String> MODULE_MEMBERS = ImmutableSet.of((Object)"__name__", (Object)"__file__", (Object)"__path__", (Object)"__doc__", (Object)"__dict__", (Object)"__package__", (Object[])new String[0]);

    public PyModuleType(@NotNull PyFile source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/psi/types/PyModuleType", "<init>"));
        }
        this(source, null);
    }

    public PyModuleType(@NotNull PyFile source, @Nullable PyImportedModule importedModule) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/psi/types/PyModuleType", "<init>"));
        }
        this.myModule = source;
        this.myImportedModule = importedModule;
    }

    @NotNull
    public PyFile getModule() {
        PyFile pyFile = this.myModule;
        if (pyFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "getModule"));
        }
        return pyFile;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PsiElement member;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyModuleType", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyModuleType", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyModuleType", "resolveMember"));
        }
        PsiElement overridingMember = PyModuleType.resolveByOverridingMembersProviders(this.myModule, name);
        if (overridingMember != null) {
            return ResolveResultList.to(overridingMember);
        }
        PsiElement attribute = this.myModule.getElementNamed(name);
        if (attribute != null) {
            return ResolveResultList.to(attribute);
        }
        if (PyUtil.isPackage(this.myModule)) {
            ArrayList<PyImportElement> importElements = new ArrayList<PyImportElement>();
            if (!(this.myImportedModule == null || location != null && PyUtil.inSameFile((PsiElement)location, this.myImportedModule))) {
                PyImportElement importElement = this.myImportedModule.getImportElement();
                if (importElement != null) {
                    importElements.add(importElement);
                }
            } else if (location != null) {
                ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)location);
                if (owner != null) {
                    importElements.addAll(PyModuleType.getVisibleImports(owner));
                }
                if (!PyUtil.inSameFile((PsiElement)location, this.myModule)) {
                    importElements.addAll(this.myModule.getImportTargets());
                }
            }
            List<? extends RatedResolveResult> implicitMembers = this.resolveImplicitPackageMember(name, importElements);
            if (implicitMembers != null) {
                return implicitMembers;
            }
        }
        if ((member = PyModuleType.resolveByMembersProviders(this.myModule, name)) != null) {
            return ResolveResultList.to(member);
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyFile module, String name) {
        for (PyModuleMembersProvider provider : (PyModuleMembersProvider[])Extensions.getExtensions(PyModuleMembersProvider.EP_NAME)) {
            PsiElement element;
            if (provider instanceof PyOverridingModuleMembersProvider || (element = provider.resolveMember(module, name)) == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(@NotNull PyFile module, @NotNull String name) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/psi/types/PyModuleType", "resolveByOverridingMembersProviders"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyModuleType", "resolveByOverridingMembersProviders"));
        }
        for (PyModuleMembersProvider provider : (PyModuleMembersProvider[])Extensions.getExtensions(PyModuleMembersProvider.EP_NAME)) {
            PsiElement element;
            if (!(provider instanceof PyOverridingModuleMembersProvider) || (element = provider.resolveMember(module, name)) == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveImplicitPackageMember(@NotNull String name, @NotNull List<PyImportElement> importElements) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyModuleType", "resolveImplicitPackageMember"));
        }
        if (importElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importElements", "com/jetbrains/python/psi/types/PyModuleType", "resolveImplicitPackageMember"));
        }
        VirtualFile moduleFile = this.myModule.getVirtualFile();
        if (moduleFile != null) {
            for (QualifiedName packageQName : QualifiedNameFinder.findImportableQNames(this.myModule, this.myModule.getVirtualFile())) {
                QualifiedName resolvingQName = packageQName.append(name);
                for (PyImportElement importElement : importElements) {
                    for (QualifiedName qName : PyModuleType.getImportedQNames(importElement)) {
                        PsiElement subModule;
                        if (!qName.matchesPrefix(resolvingQName) || (subModule = ResolveImportUtil.resolveChild(this.myModule, name, this.myModule, false, true)) == null) continue;
                        ResolveResultList results = new ResolveResultList();
                        results.add(new ImportedResolveResult(subModule, 0, Collections.singletonList(importElement)));
                        return results;
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getImportedQNames(@NotNull PyImportElement element) {
        QualifiedName importedQName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/types/PyModuleType", "getImportedQNames"));
        }
        ArrayList<QualifiedName> importedQNames = new ArrayList<QualifiedName>();
        PyStatement stmt = element.getContainingImportStatement();
        if (stmt instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)stmt;
            QualifiedName importedQName2 = fromImportStatement.getImportSourceQName();
            String visibleName = element.getVisibleName();
            if (importedQName2 != null) {
                importedQNames.add(importedQName2);
                QualifiedName implicitSubModuleQName = importedQName2.append(visibleName);
                if (implicitSubModuleQName != null) {
                    importedQNames.add(implicitSubModuleQName);
                }
            }
        } else if (stmt instanceof PyImportStatement && (importedQName = element.getImportedQName()) != null) {
            importedQNames.add(importedQName);
        }
        if (!ResolveImportUtil.isAbsoluteImportEnabledFor(element)) {
            PsiFile file = element.getContainingFile();
            if (file != null) {
                file = file.getOriginalFile();
            }
            QualifiedName absoluteQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
            if (file != null && absoluteQName != null) {
                QualifiedName prefixQName;
                QualifiedName qualifiedName = prefixQName = PyUtil.isPackage(file) ? absoluteQName : absoluteQName.removeLastComponent();
                if (prefixQName.getComponentCount() > 0) {
                    ArrayList<QualifiedName> results = new ArrayList<QualifiedName>();
                    results.addAll(importedQNames);
                    for (QualifiedName qName : importedQNames) {
                        ArrayList components = new ArrayList();
                        components.addAll(prefixQName.getComponents());
                        components.addAll(qName.getComponents());
                        results.add(QualifiedName.fromComponents(components));
                    }
                    ArrayList<QualifiedName> arrayList = results;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "getImportedQNames"));
                    }
                    return arrayList;
                }
            }
        }
        ArrayList<QualifiedName> arrayList = importedQNames;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "getImportedQNames"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PyImportElement> getVisibleImports(@NotNull ScopeOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/psi/types/PyModuleType", "getVisibleImports"));
        }
        final ArrayList<PyImportElement> visibleImports = new ArrayList<PyImportElement>();
        PyResolveUtil.scopeCrawlUp(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/types/PyModuleType$1", "execute"));
                }
                if (state2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/psi/types/PyModuleType$1", "execute"));
                }
                if (element instanceof PyImportElement) {
                    visibleImports.add((PyImportElement)element);
                }
                return true;
            }

            @Nullable
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/python/psi/types/PyModuleType$1", "getHint"));
                }
                return null;
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/types/PyModuleType$1", "handleEvent"));
                }
            }
        }, owner, null, null);
        ArrayList<PyImportElement> arrayList = visibleImports;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "getVisibleImports"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiFileSystemItem> getSubmodulesList(PsiDirectory directory, @Nullable PsiElement anchor) {
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        if (directory != null) {
            for (PsiFile psiFile : directory.getFiles()) {
                String filename = psiFile.getName();
                if ((PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !(psiFile instanceof PyFile) || filename.equals("__init__.py")) && !PyModuleType.isBinaryModule(filename)) continue;
                result.add((PsiFileSystemItem)psiFile);
            }
            for (PsiFile psiFile : directory.getSubdirectories()) {
                if (PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !PyUtil.isPackage((PsiDirectory)psiFile, anchor)) continue;
                result.add((PsiFileSystemItem)psiFile);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "getSubmodulesList"));
        }
        return arrayList;
    }

    private static boolean isExcluded(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/types/PyModuleType", "isExcluded"));
        }
        return FileIndexFacade.getInstance((Project)file.getProject()).isExcludedFile(file.getVirtualFile());
    }

    private static boolean isBinaryModule(String filename) {
        String ext = FileUtilRt.getExtension((String)filename);
        if (SystemInfo.isWindows) {
            return "pyd".equalsIgnoreCase(ext);
        }
        return "so".equals(ext);
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        List<LookupElement> result = this.getCompletionVariantsAsLookupElements(location, context, false, false);
        return result.toArray();
    }

    public List<LookupElement> getCompletionVariantsAsLookupElements(PsiElement location, ProcessingContext context, boolean wantAllSubmodules, boolean suppressParentheses) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        Set namesAlready = (Set)context.get(CTX_NAMES);
        PointInImport point = ResolveImportUtil.getPointInImport(location);
        for (PyModuleMembersProvider provider : (PyModuleMembersProvider[])Extensions.getExtensions(PyModuleMembersProvider.EP_NAME)) {
            for (PyCustomMember member : provider.getMembers(this.myModule, point)) {
                String name = member.getName();
                if (namesAlready != null) {
                    namesAlready.add(name);
                }
                if (PyUtil.isClassPrivateName(name)) continue;
                CompletionVariantsProcessor processor = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
                PsiElement resolved = member.resolve(location);
                if (resolved != null) {
                    LookupElement element;
                    processor.execute(resolved, ResolveState.initial());
                    List<LookupElement> lookupList = processor.getResultList();
                    if (!lookupList.isEmpty() && name.equals((element = lookupList.get(0)).getLookupString())) {
                        result.add(element);
                        continue;
                    }
                }
                result.add((LookupElement)LookupElementBuilder.create((String)name).withIcon(member.getIcon()).withTypeText(member.getShortType()));
            }
        }
        if (point == PointInImport.NONE || point == PointInImport.AS_NAME) {
            CompletionVariantsProcessor processor = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
            this.myModule.processDeclarations(processor, ResolveState.initial(), null, location);
            if (namesAlready != null) {
                for (LookupElement le : processor.getResultList()) {
                    String name = le.getLookupString();
                    if (namesAlready.contains(name)) continue;
                    result.add(le);
                    namesAlready.add(name);
                }
            } else {
                result.addAll(processor.getResultList());
            }
        }
        if (PyUtil.isPackage(this.myModule)) {
            if (point == PointInImport.AS_MODULE || point == PointInImport.AS_NAME || wantAllSubmodules) {
                result.addAll(PyModuleType.getSubModuleVariants(this.myModule.getContainingDirectory(), location, namesAlready));
            } else {
                this.addImportedSubmodules(location, namesAlready, result);
            }
        }
        return result;
    }

    @NotNull
    private static CompletionVariantsProcessor createCompletionVariantsProcessor(PsiElement location, boolean suppressParentheses, PointInImport point) {
        CompletionVariantsProcessor processor = new CompletionVariantsProcessor(location, new Condition<PsiElement>(){

            public boolean value(PsiElement psiElement) {
                return !(psiElement instanceof PyImportElement) || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyImportStatementBase.class) instanceof PyFromImportStatement;
            }
        }, null);
        if (suppressParentheses) {
            processor.suppressParentheses();
        }
        processor.setPlainNamesOnly(point == PointInImport.AS_NAME);
        CompletionVariantsProcessor completionVariantsProcessor = processor;
        if (completionVariantsProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "createCompletionVariantsProcessor"));
        }
        return completionVariantsProcessor;
    }

    private void addImportedSubmodules(PsiElement location, Set<String> existingNames, List<LookupElement> result) {
        PsiFile file = location.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            PyFile moduleBase = PyUtil.isPackage(this.myModule) ? this.myModule.getContainingDirectory() : this.myModule;
            for (PyImportElement importElement : pyFile.getImportTargets()) {
                PsiElement target = PyUtil.turnInitIntoDir(importElement.resolve());
                if (target == null || !PsiTreeUtil.isAncestor((PsiElement)moduleBase, (PsiElement)target, (boolean)true)) continue;
                LookupElementBuilder element = null;
                if (target instanceof PsiFileSystemItem) {
                    element = PyModuleType.buildFileLookupElement((PsiFileSystemItem)target, existingNames);
                } else if (target instanceof PsiNamedElement) {
                    element = LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)target));
                }
                if (element == null) continue;
                result.add((LookupElement)element);
            }
        }
    }

    public static List<LookupElement> getSubModuleVariants(PsiDirectory directory, PsiElement location, Set<String> namesAlready) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiFileSystemItem item : PyModuleType.getSubmodulesList(directory, location)) {
            LookupElementBuilder lookupElement;
            if (item == location.getContainingFile().getOriginalFile() || (lookupElement = PyModuleType.buildFileLookupElement(item, namesAlready)) == null) continue;
            result.add((LookupElement)lookupElement);
        }
        return result;
    }

    @Nullable
    public static LookupElementBuilder buildFileLookupElement(PsiFileSystemItem item, @Nullable Set<String> existingNames) {
        String s = FileUtil.getNameWithoutExtension((String)item.getName());
        if (!PyNames.isIdentifier(s)) {
            return null;
        }
        if (existingNames != null) {
            if (existingNames.contains(s)) {
                return null;
            }
            existingNames.add(s);
        }
        return LookupElementBuilder.create((Object)item, (String)s).withTypeText(PyModuleType.getPresentablePath((PsiDirectory)item.getParent())).withPresentableText(s).withIcon(item.getIcon(0));
    }

    private static String getPresentablePath(PsiDirectory directory) {
        if (directory == null) {
            return "";
        }
        String path = directory.getVirtualFile().getPath();
        if (path.contains("python_stubs")) {
            return "<built-in>";
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @Override
    public String getName() {
        return this.myModule.getName();
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public void assertValid(String message) {
        if (!this.myModule.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myModule, this.myModule.getClass().toString() + ": " + message);
        }
    }

    @NotNull
    public static Set<String> getPossibleInstanceMembers() {
        ImmutableSet<String> immutableSet = MODULE_MEMBERS;
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyModuleType", "getPossibleInstanceMembers"));
        }
        return immutableSet;
    }
}

