/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.resolve.PointInImport;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public abstract class PyModuleMembersProvider {
    public static final ExtensionPointName<PyModuleMembersProvider> EP_NAME = ExtensionPointName.create((String)"Pythonid.pyModuleMembersProvider");

    public Collection<PyCustomMember> getMembers(PyFile module, PointInImport point) {
        String qName;
        VirtualFile vFile = module.getVirtualFile();
        if (vFile != null && (qName = PyPsiFacade.getInstance(module.getProject()).findShortestImportableName(vFile, module)) != null) {
            return this.getMembersByQName(module, qName);
        }
        return Collections.emptyList();
    }

    @Nullable
    public PsiElement resolveMember(PyFile module, String name) {
        for (PyCustomMember o : this.getMembers(module, PointInImport.NONE)) {
            if (!o.getName().equals(name)) continue;
            return o.resolve(module);
        }
        return null;
    }

    protected abstract Collection<PyCustomMember> getMembersByQName(PyFile var1, String var2);
}

