/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportedModuleType
implements PyType {
    @NotNull
    private PyImportedModule myImportedModule;

    public PyImportedModuleType(@NotNull PyImportedModule importedModule) {
        if (importedModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedModule", "com/jetbrains/python/psi/types/PyImportedModuleType", "<init>"));
        }
        this.myImportedModule = importedModule;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyImportedModuleType", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyImportedModuleType", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyImportedModuleType", "resolveMember"));
        }
        PsiElement resolved = this.myImportedModule.resolve();
        if (resolved instanceof PyFile) {
            PyFile file = (PyFile)resolved;
            return new PyModuleType(file, this.myImportedModule).resolveMember(name, location, direction, resolveContext);
        }
        if (resolved instanceof PsiDirectory) {
            List<PsiElement> elements = Collections.singletonList(ResolveImportUtil.resolveChild(resolved, name, null, true, true));
            return ResolveImportUtil.rateResults(elements);
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        PsiDirectory dir;
        ArrayList<Object> result = new ArrayList<Object>();
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(location);
        assert (scopeOwner != null);
        List<PyImportElement> importTargets = PyModuleType.getVisibleImports(scopeOwner);
        int imported = this.myImportedModule.getImportedPrefix().getComponentCount();
        for (PyImportElement importTarget : importTargets) {
            List components;
            QualifiedName qName = importTarget.getImportedQName();
            if (qName == null || !qName.matchesPrefix(this.myImportedModule.getImportedPrefix()) || (components = qName.getComponents()).size() <= imported) continue;
            String module = (String)components.get(imported);
            result.add(LookupElementBuilder.create((String)module));
        }
        PsiElement resolved = this.myImportedModule.resolve();
        if (resolved instanceof PsiDirectory && PyUtil.isPackage(dir = (PsiDirectory)resolved, location)) {
            result.addAll(PyModuleType.getSubModuleVariants(dir, location, null));
        }
        return ArrayUtil.toObjectArray(result);
    }

    @Override
    public String getName() {
        return "imported module " + this.myImportedModule.getImportedPrefix().toString();
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    @NotNull
    public PyImportedModule getImportedModule() {
        PyImportedModule pyImportedModule = this.myImportedModule;
        if (pyImportedModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyImportedModuleType", "getImportedModule"));
        }
        return pyImportedModule;
    }
}

