/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionType
implements PyCallableType {
    @NotNull
    private final Callable myCallable;

    public PyFunctionType(@NotNull Callable callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/psi/types/PyFunctionType", "<init>"));
        }
        this.myCallable = callable;
    }

    @Override
    public boolean isCallable() {
        return true;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyFunctionType", "getReturnType"));
        }
        return context.getReturnType(this.myCallable);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyFunctionType", "getCallType"));
        }
        if (callSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSite", "com/jetbrains/python/psi/types/PyFunctionType", "getCallType"));
        }
        return this.myCallable.getCallType(context, callSite);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyFunctionType", "getParameters"));
        }
        ArrayList<PyCallableParameter> result = new ArrayList<PyCallableParameter>();
        for (PyParameter parameter : this.myCallable.getParameterList().getParameters()) {
            result.add(new PyCallableParameterImpl(parameter));
        }
        return result;
    }

    @Override
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyFunctionType", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyFunctionType", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyFunctionType", "resolveMember"));
        }
        PyClassTypeImpl delegate = this.selectFakeType(location, resolveContext.getTypeEvalContext());
        if (delegate == null) {
            return Collections.emptyList();
        }
        return delegate.resolveMember(name, location, direction, resolveContext);
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(location.getProject(), location.getContainingFile());
        PyClassTypeImpl delegate = location instanceof PyReferenceExpression ? this.selectFakeType(((PyReferenceExpression)location).getQualifier(), typeEvalContext) : PyBuiltinCache.getInstance((PsiElement)this.getCallable()).getObjectType("__function");
        if (delegate == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return delegate.getCompletionVariants(completionPrefix, location, context);
    }

    @Nullable
    private PyClassTypeImpl selectFakeType(@Nullable PyExpression location, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyFunctionType", "selectFakeType"));
        }
        String fakeClassName = location instanceof PyReferenceExpression && this.isBoundMethodReference((PyReferenceExpression)location, context) ? "__method" : "__function";
        return PyBuiltinCache.getInstance((PsiElement)this.getCallable()).getObjectType(fakeClassName);
    }

    private boolean isBoundMethodReference(@NotNull PyReferenceExpression location, @NotNull TypeEvalContext context) {
        boolean isNonStaticMethod;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/psi/types/PyFunctionType", "isBoundMethodReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyFunctionType", "isBoundMethodReference"));
        }
        PyFunction function = PyUtil.as(this.getCallable(), PyFunction.class);
        boolean bl = isNonStaticMethod = function != null && function.getContainingClass() != null && function.getModifier() != PyFunction.Modifier.STATICMETHOD;
        if (isNonStaticMethod) {
            PyExpression qualifier;
            if (LanguageLevel.forElement((PsiElement)location).isOlderThan(LanguageLevel.PYTHON30)) {
                return true;
            }
            if (location.isQualified()) {
                qualifier = location.getQualifier();
            } else {
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                QualifiedResolveResult resolveResult = location.followAssignmentsChain(resolveContext);
                List<PyExpression> qualifiers = resolveResult.getQualifiers();
                PyExpression pyExpression = qualifier = ContainerUtil.isEmpty(qualifiers) ? null : qualifiers.get(qualifiers.size() - 1);
            }
            if (qualifier != null) {
                PyType qualifierType = PyTypeChecker.toNonWeakType(context.getType(qualifier), context);
                if (PyFunctionType.isInstanceType(qualifierType)) {
                    return true;
                }
                if (qualifierType instanceof PyUnionType) {
                    for (PyType type : ((PyUnionType)qualifierType).getMembers()) {
                        if (!PyFunctionType.isInstanceType(type)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isInstanceType(@Nullable PyType type) {
        return type instanceof PyClassType && !((PyClassType)type).isDefinition();
    }

    @Override
    public String getName() {
        return "function";
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }

    @NotNull
    public Callable getCallable() {
        Callable callable = this.myCallable;
        if (callable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyFunctionType", "getCallable"));
        }
        return callable;
    }

    @Nullable
    public static String getParameterName(@NotNull PyNamedParameter namedParameter) {
        if (namedParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedParameter", "com/jetbrains/python/psi/types/PyFunctionType", "getParameterName"));
        }
        String name = namedParameter.getName();
        if (namedParameter.isPositionalContainer()) {
            name = "*" + name;
        } else if (namedParameter.isKeywordContainer()) {
            name = "**" + name;
        }
        return name;
    }
}

