/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCollectionTypeImpl
extends PyClassTypeImpl
implements PyCollectionType {
    private final PyType myElementType;

    public PyCollectionTypeImpl(@NotNull PyClass source, boolean isDefinition, PyType elementType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/psi/types/PyCollectionTypeImpl", "<init>"));
        }
        super(source, isDefinition);
        this.myElementType = elementType;
    }

    @Override
    public PyType getElementType(TypeEvalContext context) {
        return this.myElementType;
    }

    @Nullable
    public static PyCollectionTypeImpl createTypeByQName(@NotNull Project project, String classQualifiedName, boolean isDefinition, PyType elementType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/types/PyCollectionTypeImpl", "createTypeByQName"));
        }
        PyClass pyClass = PyClassNameIndex.findClass(classQualifiedName, project);
        if (pyClass == null) {
            return null;
        }
        return new PyCollectionTypeImpl(pyClass, isDefinition, elementType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PyCollectionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyCollectionType type = (PyCollectionType)o;
        TypeEvalContext context = TypeEvalContext.codeInsightFallback(this.myClass.getProject());
        return !(this.myElementType != null ? !this.myElementType.equals(type.getElementType(context)) : type.getElementType(context) != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myElementType != null ? this.myElementType.hashCode() : 0);
        return result;
    }
}

