/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PyCustomMemberUtils;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingAncestorsClassMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingClassMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassTypeImpl
extends UserDataHolderBase
implements PyClassType {
    @NotNull
    protected final PyClass myClass;
    protected final boolean myIsDefinition;
    private static ThreadLocal<Set<Pair<PyClass, String>>> ourResolveMemberStack = new ThreadLocal<Set<Pair<PyClass, String>>>(){

        @Override
        protected Set<Pair<PyClass, String>> initialValue() {
            return new HashSet<Pair<PyClass, String>>();
        }
    };
    private static Key<Set<PyClassType>> CTX_VISITED = Key.create((String)"PyClassType.Visited");
    public static Key<Boolean> CTX_SUPPRESS_PARENTHESES = Key.create((String)"PyFunction.SuppressParentheses");

    public PyClassTypeImpl(@NotNull PyClass source, boolean isDefinition) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/psi/types/PyClassTypeImpl", "<init>"));
        }
        PyClass originalElement = CompletionUtil.getOriginalElement(source);
        this.myClass = originalElement != null ? originalElement : source;
        this.myIsDefinition = isDefinition;
    }

    public <T> PyClassTypeImpl withUserData(Key<T> key, T value) {
        this.putUserData(key, value);
        return this;
    }

    @Override
    @NotNull
    public PyClass getPyClass() {
        PyClass pyClass = this.myClass;
        if (pyClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getPyClass"));
        }
        return pyClass;
    }

    @Override
    public boolean isDefinition() {
        return this.myIsDefinition;
    }

    @Override
    public PyClassType toInstance() {
        return this.myIsDefinition ? new PyClassTypeImpl(this.myClass, false) : this;
    }

    @Override
    @Nullable
    public String getClassQName() {
        return this.myClass.getQualifiedName();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getSuperClassTypes"));
        }
        List<PyClassLikeType> list = this.myClass.getSuperClassTypes(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getSuperClassTypes"));
        }
        return list;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveMember"));
        }
        return this.resolveMember(name, location, direction, resolveContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        Pair key;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveMember"));
        }
        Set<Pair<PyClass, String>> resolving = ourResolveMemberStack.get();
        if (resolving.contains(key = Pair.create((Object)this.myClass, (Object)name))) {
            return Collections.emptyList();
        }
        resolving.add((Pair<PyClass, String>)key);
        try {
            List<? extends RatedResolveResult> list = this.doResolveMember(name, location, direction, resolveContext, inherited);
            return list;
        }
        finally {
            resolving.remove(key);
        }
    }

    @Nullable
    private List<? extends RatedResolveResult> doResolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        List<? extends RatedResolveResult> typeMembers;
        PyClassLikeType typeType;
        PyType first_arg_type;
        PyExpression first_arg;
        Ref<ResolveResultList> resultRef;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyClassTypeImpl", "doResolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyClassTypeImpl", "doResolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyClassTypeImpl", "doResolveMember"));
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        PsiElement classMember = PyClassTypeImpl.resolveByOverridingMembersProviders(this, name, (PsiElement)location);
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (resolveContext.allowProperties() && (resultRef = this.findProperty(name, direction, true)) != null) {
            return (List)resultRef.get();
        }
        if ("super".equals(this.getClassQName()) && this.isBuiltin() && location instanceof PyCallExpression && (first_arg = ((PyCallExpression)location).getArgument(0, PyExpression.class)) != null && (first_arg_type = context.getType(first_arg)) instanceof PyClassType) {
            PyClass derived_class = ((PyClassType)first_arg_type).getPyClass();
            Iterator<PyClass> base_it = derived_class.getAncestorClasses(context).iterator();
            if (base_it.hasNext()) {
                return new PyClassTypeImpl(base_it.next(), true).resolveMember(name, location, direction, resolveContext);
            }
            return null;
        }
        classMember = PyClassTypeImpl.resolveClassMember(this.myClass, this.myIsDefinition, name, location);
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        classMember = PyClassTypeImpl.resolveByOverridingAncestorsMembersProviders(this, name, location);
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (inherited) {
            for (PyClassLikeType type : this.myClass.getAncestorTypes(context)) {
                List<? extends RatedResolveResult> results;
                if (type instanceof PyClassType) {
                    PsiElement superMember;
                    if (!this.myIsDefinition) {
                        type = type.toInstance();
                    }
                    if ((superMember = PyClassTypeImpl.resolveClassMember(((PyClassType)type).getPyClass(), this.myIsDefinition, name, null)) != null) {
                        return ResolveResultList.to(superMember);
                    }
                }
                if (type == null || (results = type.resolveMember(name, location, direction, resolveContext, false)) == null || results.isEmpty()) continue;
                return results;
            }
        }
        if (this.isDefinition() && this.myClass.isNewStyleClass() && (typeType = this.getMetaClassType(context, inherited)) != null && (typeMembers = typeType.resolveMember(name, location, direction, resolveContext)) != null && !typeMembers.isEmpty()) {
            return typeMembers;
        }
        if (inherited) {
            classMember = PyClassTypeImpl.resolveByMembersProviders(this, name, (PsiElement)location);
        }
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (inherited) {
            for (PyClassLikeType type : this.myClass.getAncestorTypes(context)) {
                PyClass pyClass;
                PsiElement superMember;
                if (!(type instanceof PyClassType) || (superMember = PyClassTypeImpl.resolveByMembersProviders(new PyClassTypeImpl(pyClass = ((PyClassType)type).getPyClass(), this.isDefinition()), name, (PsiElement)location)) == null) continue;
                return ResolveResultList.to(superMember);
            }
        }
        return Collections.emptyList();
    }

    private Ref<ResolveResultList> findProperty(String name, AccessDirection direction, boolean inherited) {
        Maybe<Callable> accessor;
        Ref resultRef = null;
        Property property = this.myClass.findProperty(name, inherited);
        if (property != null && (accessor = property.getByDirection(direction)).isDefined()) {
            PyTargetExpression site;
            Callable accessor_code = accessor.value();
            ResolveResultList ret = new ResolveResultList();
            if (accessor_code != null) {
                ret.poke((PsiElement)accessor_code, 0);
            }
            if ((site = property.getDefinitionSite()) != null) {
                ret.poke((PsiElement)site, -1000);
            }
            resultRef = ret.size() > 0 ? Ref.create((Object)ret) : Ref.create();
        }
        return resultRef;
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getMetaClassType"));
        }
        PyType ownMeta = this.myClass.getMetaClassType(context);
        if (ownMeta != null) {
            return ownMeta instanceof PyClassLikeType ? (PyClassLikeType)ownMeta : null;
        }
        if (inherited) {
            for (PyClassLikeType ancestor : this.myClass.getAncestorTypes(context)) {
                PyClassLikeType ancestorMeta;
                if (ancestor == null || (ancestorMeta = ancestor.getMetaClassType(context, false)) == null) continue;
                return ancestorMeta;
            }
            return PyBuiltinCache.getInstance(this.myClass).getObjectType("type");
        }
        return null;
    }

    @Override
    public boolean isCallable() {
        if (this.isDefinition()) {
            return true;
        }
        if (PyClassTypeImpl.isMethodType(this)) {
            return true;
        }
        PyClass cls = this.getPyClass();
        return PyABCUtil.isSubclass(cls, "Callable");
    }

    private static boolean isMethodType(@NotNull PyClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/types/PyClassTypeImpl", "isMethodType"));
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(type.getPyClass());
        return type.equals(builtinCache.getClassMethodType()) || type.equals(builtinCache.getStaticMethodType());
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getReturnType"));
        }
        if (this.isDefinition()) {
            return new PyClassTypeImpl(this.getPyClass(), false);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getCallType"));
        }
        if (callSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSite", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getCallType"));
        }
        return this.getReturnType(context);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getParameters"));
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveClassMember(@NotNull PyClass cls, boolean isDefinition, @NotNull String name, @Nullable PyExpression location) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveClassMember"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveClassMember"));
        }
        PsiElement result = PyClassTypeImpl.resolveInner(cls, isDefinition, name, location);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyClassType aClass, String name, @Nullable PsiElement location) {
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            PsiElement resolveResult = provider.resolveMember(aClass, name, location);
            if (resolveResult == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(PyClassType aClass, String name, @Nullable PsiElement location) {
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingClassMembersProvider) || (resolveResult = provider.resolveMember(aClass, name, location)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingAncestorsMembersProviders(PyClassType type, String name, @Nullable PyExpression location) {
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingAncestorsClassMembersProvider) || (resolveResult = provider.resolveMember(type, name, (PsiElement)location)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveInner(@NotNull PyClass cls, boolean isDefinition, @NotNull String name, @Nullable PyExpression location) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveInner"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyClassTypeImpl", "resolveInner"));
        }
        ResolveProcessor processor = new ResolveProcessor(name);
        if (!isDefinition && !cls.processInstanceLevelDeclarations(processor, (PsiElement)location)) {
            return processor.getResult();
        }
        cls.processClassLevelDeclarations(processor);
        return processor.getResult();
    }

    @Override
    public Object[] getCompletionVariants(String prefix, PsiElement location, ProcessingContext context) {
        PyClassLikeType typeType;
        PyBuiltinCache cache;
        PyClassType classobjType;
        HashSet<PyClassTypeImpl> visited = (HashSet<PyClassTypeImpl>)context.get(CTX_VISITED);
        if (visited == null) {
            visited = new HashSet<PyClassTypeImpl>();
            context.put(CTX_VISITED, visited);
        }
        if (visited.contains(this)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        visited.add(this);
        HashSet<String> namesAlready = (HashSet<String>)context.get(CTX_NAMES);
        if (namesAlready == null) {
            namesAlready = new HashSet<String>();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean suppressParentheses = context.get(CTX_SUPPRESS_PARENTHESES) != null;
        this.addOwnClassMembers(location, namesAlready, suppressParentheses, ret);
        PsiFile origin = location != null ? CompletionUtil.getOriginalOrSelf(location).getContainingFile() : null;
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(this.myClass.getProject(), origin);
        this.addInheritedMembers(prefix, location, namesAlready, context, ret, typeEvalContext);
        for (PyClassMembersProvider provider : (PyClassMembersProvider[])Extensions.getExtensions(PyClassMembersProvider.EP_NAME)) {
            for (PyCustomMember member : provider.getMembers(this, location)) {
                String name = member.getName();
                if (namesAlready.contains(name)) continue;
                ret.add(PyCustomMemberUtils.toLookUpElement(member, this.getName()));
            }
        }
        if (!this.myClass.isNewStyleClass() && (classobjType = (cache = PyBuiltinCache.getInstance(this.myClass)).getOldstyleClassobjType()) != null) {
            ret.addAll(Arrays.asList(classobjType.getCompletionVariants(prefix, location, context)));
        }
        if (this.isDefinition() && this.myClass.isNewStyleClass() && (typeType = this.getMetaClassType(typeEvalContext, true)) != null) {
            Collections.addAll(ret, typeType.getCompletionVariants(prefix, location, context));
        }
        return ret.toArray();
    }

    private void addOwnClassMembers(PsiElement expressionHook, Set<String> namesAlready, boolean suppressParentheses, List<Object> ret) {
        List<String> slots;
        PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)expressionHook, PyClass.class);
        if (containingClass != null) {
            containingClass = CompletionUtil.getOriginalElement(containingClass);
        }
        boolean withinOurClass = containingClass == this.getPyClass() || PyClassTypeImpl.isInSuperCall(expressionHook);
        CompletionVariantsProcessor processor = new CompletionVariantsProcessor(expressionHook, new PyResolveUtil.FilterNotInstance(this.myClass), null);
        if (suppressParentheses) {
            processor.suppressParentheses();
        }
        this.myClass.processClassLevelDeclarations(processor);
        List<String> list = slots = this.myClass.isNewStyleClass() ? this.myClass.getSlots() : null;
        if (slots != null) {
            processor.setAllowedNames(slots);
        }
        this.myClass.processInstanceLevelDeclarations(processor, expressionHook);
        for (LookupElement le : processor.getResultList()) {
            String name = le.getLookupString();
            if (namesAlready.contains(name) || !withinOurClass && PyClassTypeImpl.isClassPrivate(name)) continue;
            namesAlready.add(name);
            ret.add(le);
        }
        if (slots != null) {
            for (String name : slots) {
                if (namesAlready.contains(name)) continue;
                ret.add(LookupElementBuilder.create((String)name));
            }
        }
    }

    private static boolean isInSuperCall(PsiElement hook) {
        if (hook instanceof PyReferenceExpression) {
            PyExpression qualifier = ((PyReferenceExpression)hook).getQualifier();
            return qualifier instanceof PyCallExpression && ((PyCallExpression)qualifier).isCalleeText("super");
        }
        return false;
    }

    private void addInheritedMembers(String name, PsiElement expressionHook, Set<String> namesAlready, ProcessingContext context, List<Object> ret, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeEvalContext", "com/jetbrains/python/psi/types/PyClassTypeImpl", "addInheritedMembers"));
        }
        for (PyExpression expression : this.myClass.getSuperClassExpressions()) {
            Object[] ancestry;
            PyType type;
            PsiReference reference = expression.getReference();
            PsiElement element = null;
            if (reference != null) {
                element = reference.resolve();
            }
            if (element instanceof PyClass) {
                type = new PyClassTypeImpl((PyClass)element, this.myIsDefinition);
            } else {
                type = typeEvalContext.getType(expression);
                if (type instanceof PyClassType && !this.myIsDefinition) {
                    type = ((PyClassType)type).toInstance();
                }
            }
            if (type == null) continue;
            for (Object ob : ancestry = type.getCompletionVariants(name, expressionHook, context)) {
                String inheritedName = ob.toString();
                if (namesAlready.contains(inheritedName) || PyClassTypeImpl.isClassPrivate(inheritedName)) continue;
                ret.add(ob);
                namesAlready.add(inheritedName);
            }
            ContainerUtil.addAll(ret, (Object[])ancestry);
        }
    }

    private static boolean isClassPrivate(String lookup_string) {
        return lookup_string.startsWith("__") && !lookup_string.endsWith("__");
    }

    @Override
    public String getName() {
        return this.getPyClass().getName();
    }

    @Override
    public boolean isBuiltin() {
        return PyBuiltinCache.getInstance(this.myClass).isBuiltin(this.myClass);
    }

    @Override
    public void assertValid(String message) {
        if (!this.myClass.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myClass, this.myClass.getClass().toString() + ": " + message);
        }
    }

    @NotNull
    public Set<String> getPossibleInstanceMembers() {
        HashSet ret = new HashSet();
        Set<String> set = Collections.unmodifiableSet(ret);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyClassTypeImpl", "getPossibleInstanceMembers"));
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyClassTypeImpl classType = (PyClassTypeImpl)o;
        if (this.myIsDefinition != classType.myIsDefinition) {
            return false;
        }
        return this.myClass.equals(classType.myClass);
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + (this.myIsDefinition ? 1 : 0);
        return result;
    }

    public static boolean is(@NotNull String qName, PyType type) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/psi/types/PyClassTypeImpl", "is"));
        }
        if (type instanceof PyClassType) {
            return qName.equals(((PyClassType)type).getClassQName());
        }
        return false;
    }

    public String toString() {
        return (this.isValid() ? "" : "[INVALID] ") + "PyClassType: " + this.getClassQName();
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid();
    }

    @Nullable
    public static PyClassTypeImpl createTypeByQName(@NotNull Project project, String classQualifiedName, boolean isDefinition) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/types/PyClassTypeImpl", "createTypeByQName"));
        }
        PyClass pyClass = PyClassNameIndex.findClass(classQualifiedName, project);
        if (pyClass == null) {
            return null;
        }
        return new PyClassTypeImpl(pyClass, isDefinition);
    }
}

