/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassMembersProviderBase
implements PyClassMembersProvider {
    @Override
    @NotNull
    public Collection<PyCustomMember> getMembers(PyClassType clazz, PsiElement location) {
        List<PyCustomMember> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/types/PyClassMembersProviderBase", "getMembers"));
        }
        return list;
    }

    @Override
    public PsiElement resolveMember(PyClassType clazz, String name, PsiElement location) {
        Collection<PyCustomMember> members = this.getMembers(clazz, location);
        return PyClassMembersProviderBase.resolveMemberByName(members, clazz, name);
    }

    @Nullable
    public static PsiElement resolveMemberByName(Collection<PyCustomMember> members, PyClassType clazz, String name) {
        PyClass pyClass = clazz.getPyClass();
        for (PyCustomMember member : members) {
            if (!member.getName().equals(name)) continue;
            return member.resolve(pyClass);
        }
        return null;
    }
}

