/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallableTypeImpl
implements PyCallableType {
    @Nullable
    private final List<PyCallableParameter> myParameters;
    @Nullable
    private final PyType myReturnType;

    public PyCallableTypeImpl(@Nullable List<PyCallableParameter> parameters, @Nullable PyType returnType) {
        this.myParameters = parameters;
        this.myReturnType = returnType;
    }

    @Override
    public boolean isCallable() {
        return true;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "getReturnType"));
        }
        return this.myReturnType;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "getCallType"));
        }
        if (callSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSite", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "getCallType"));
        }
        return this.myReturnType;
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "getParameters"));
        }
        return this.myParameters;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/psi/types/PyCallableTypeImpl", "resolveMember"));
        }
        return null;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        return new Object[0];
    }

    @Override
    @Nullable
    public String getName() {
        final TypeEvalContext context = TypeEvalContext.codeInsightFallback(null);
        return String.format("(%s) -> %s", this.myParameters != null ? StringUtil.join(this.myParameters, (Function)new Function<PyCallableParameter, String>(){

            public String fun(PyCallableParameter param) {
                if (param != null) {
                    StringBuilder builder = new StringBuilder();
                    String name = param.getName();
                    PyType type = param.getType(context);
                    if (name != null) {
                        builder.append(name);
                        if (type != null) {
                            builder.append(": ");
                        }
                    }
                    builder.append(type != null ? type.getName() : "unknown");
                    return builder.toString();
                }
                return "unknown";
            }
        }, (String)", ") : "...", this.myReturnType != null ? this.myReturnType.getName() : "unknown");
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public void assertValid(String message) {
    }
}

