/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyABCUtil {
    private PyABCUtil() {
    }

    public static boolean isSubclass(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/jetbrains/python/psi/types/PyABCUtil", "isSubclass"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/jetbrains/python/psi/types/PyABCUtil", "isSubclass"));
        }
        String superName = superClass.getName();
        if (superName != null) {
            return PyABCUtil.isSubclass(subClass, superName, true);
        }
        return false;
    }

    public static boolean isSubclass(@NotNull PyClass subClass, @NotNull String superClassName) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/jetbrains/python/psi/types/PyABCUtil", "isSubclass"));
        }
        if (superClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassName", "com/jetbrains/python/psi/types/PyABCUtil", "isSubclass"));
        }
        return PyABCUtil.isSubclass(subClass, superClassName, true);
    }

    public static boolean isSubclass(@NotNull PyClass subClass, @NotNull String superClassName, boolean inherited) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/jetbrains/python/psi/types/PyABCUtil", "isSubclass"));
        }
        if (superClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassName", "com/jetbrains/python/psi/types/PyABCUtil", "isSubclass"));
        }
        if ("Callable".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__call__", inherited);
        }
        if ("Hashable".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__hash__", inherited);
        }
        boolean hasIter = PyABCUtil.hasMethod(subClass, "__iter__", inherited);
        boolean hasGetItem = PyABCUtil.hasMethod(subClass, "__getitem__", inherited);
        if ("Iterable".equals(superClassName)) {
            return hasIter || hasGetItem;
        }
        if ("Iterator".equals(superClassName)) {
            return hasIter && (PyABCUtil.hasMethod(subClass, "next", inherited) || PyABCUtil.hasMethod(subClass, "__next__", inherited)) || hasGetItem;
        }
        boolean isSized = PyABCUtil.hasMethod(subClass, "__len__", inherited);
        if ("Sized".equals(superClassName)) {
            return isSized;
        }
        boolean isContainer = PyABCUtil.hasMethod(subClass, "__contains__", inherited);
        if ("Container".equals(superClassName)) {
            return isContainer;
        }
        if ("Sequence".equals(superClassName)) {
            return isSized && hasIter && isContainer && hasGetItem;
        }
        if ("Mapping".equals(superClassName)) {
            return isSized && hasIter && isContainer && hasGetItem && PyABCUtil.hasMethod(subClass, "keys", inherited);
        }
        if ("Complex".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__complex__", inherited);
        }
        if ("Real".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__float__", inherited);
        }
        if ("Integral".equals(superClassName)) {
            return PyABCUtil.hasMethod(subClass, "__int__", inherited);
        }
        return "Number".equals(superClassName) && "Decimal".equals(subClass.getName());
    }

    public static boolean isSubtype(@NotNull PyType type, @NotNull String superClassName, @NotNull TypeEvalContext context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/types/PyABCUtil", "isSubtype"));
        }
        if (superClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassName", "com/jetbrains/python/psi/types/PyABCUtil", "isSubtype"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/types/PyABCUtil", "isSubtype"));
        }
        if (type instanceof PyClassType) {
            PyClassType classType = (PyClassType)type;
            PyClass pyClass = classType.getPyClass();
            if (classType.isDefinition()) {
                PyClassLikeType metaClassType = classType.getMetaClassType(context, true);
                if (metaClassType instanceof PyClassType) {
                    PyClassType metaClass = (PyClassType)metaClassType;
                    return PyABCUtil.isSubclass(metaClass.getPyClass(), superClassName, true);
                }
            } else {
                return PyABCUtil.isSubclass(pyClass, superClassName, true);
            }
        }
        if (type instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)type;
            for (PyType m : unionType.getMembers()) {
                if (m == null || PyABCUtil.isSubtype(m, superClassName, context)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean hasMethod(PyClass cls, String name, boolean inherited) {
        return cls.findMethodByName(name, inherited) != null || cls.findClassAttribute(name, inherited) != null;
    }
}

