/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PySetuptoolsNamespaceIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> NAME = ID.create((String)"Py.setuptools.namespace");
    private static final Pattern RE_NAMESPACE = Pattern.compile("sys\\.modules\\.setdefault\\('([^']*)'");
    private static final String NAMESPACE_FILE_SUFFIX = "-nspkg.pth";
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();
    private final DataIndexer<String, Void, FileContent> myDataIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex$1", "map"));
            }
            CharSequence content = inputData.getContentAsText();
            Matcher matcher = RE_NAMESPACE.matcher(content);
            HashMap<String, Void> results = new HashMap<String, Void>();
            while (matcher.find()) {
                String packageName = matcher.group(1);
                results.put(packageName, null);
            }
            HashMap<String, Void> hashMap = results;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex$1", "map"));
            }
            return hashMap;
        }
    };
    private FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex$2", "acceptInput"));
            }
            return file.getName().endsWith(PySetuptoolsNamespaceIndex.NAMESPACE_FILE_SUFFIX);
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.myKeyDescriptor;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public static Collection<VirtualFile> find(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "find"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "find"));
        }
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope(project);
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)name, scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PySetuptoolsNamespaceIndex", "find"));
        }
        return collection;
    }
}

